/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Collections;
import java.util.List;

public class ListComponentsOperation
extends AbstractListEndpointsOperation {
    public static final String NAME = "list components";

    public ListComponentsOperation() {
        super(NAME);
    }

    @Override
    String getEndpointName() {
        return "component";
    }

    @Override
    void addForModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR", false).addParameter(new IdentifierParameter("Owner"))).setSyntaxHintSpace());
    }

    @Override
    String getForDescription(String endpointsName) {
        return "\n   for <Owner>        - Returns a list of " + endpointsName + " owned by the specified user or group.";
    }

    @Override
    String getForExamples(String name) {
        return "\n" + name + " for User1\n";
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListComponentsOperation.createResultDescriptor());
        ListComponentsOperation.addComponents(session, this.getComponents(definition.eventScope), definition.isAll, definition.owner, result);
        return new SLResponse(result);
    }

    public static void addComponents(MFSession session, List<ComponentReference> components, boolean isAll, String owner, RowSet result) throws Exception {
        Collections.sort(components);
        for (ComponentReference component : components) {
            String componentOwner = component.getSecurityContext() != null ? component.getSecurityContext().getOwnerName() : null;
            List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
            if (!ListComponentsOperation.isAll(isAll, session) && ListComponentsOperation.isSystemComponent(component.getModel(), nameTokens.get(2)) || !ListComponentsOperation.checkSysadmin(session, componentOwner) || !ListComponentsOperation.checkOwner(owner, componentOwner)) continue;
            result.addToRowSet(ListComponentsOperation.createRow(nameTokens, component));
        }
    }

    private static boolean checkOwner(String owner, String componentOwner) {
        return owner == null || owner.equalsIgnoreCase(componentOwner);
    }

    private static Object[] createRow(List<String> nameTokens, ComponentReference component) {
        return new Object[]{nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), ListComponentsOperation.skipNull(component.getDescription()), component.getModel().toString(), component.getEventScope(), component.getSecurityContext() != null ? component.getSecurityContext().getOwnerName() : "", component.getAddress(), ListComponentsOperation.getCreationTime(component)};
    }

    public static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListComponentsOperation.addColumn(result, "Node");
        ListComponentsOperation.addColumn(result, "Type");
        ListComponentsOperation.addColumn(result, "Name");
        ListComponentsOperation.addColumn(result, "Description");
        ListComponentsOperation.addColumn(result, "Model");
        ListComponentsOperation.addColumn(result, "Scope");
        ListComponentsOperation.addColumn(result, "Owner");
        ListComponentsOperation.addColumn(result, "Address");
        ListComponentsOperation.addColumn(result, "Created On");
        return result;
    }

    @Override
    Definition createDefinition(DSLStatement statement) throws ParsingException {
        return new Definition(this.syntax, statement);
    }

    public static class Definition
    extends AbstractListEndpointsOperation.Definition {
        private String owner;

        Definition(DSLStatementSyntax syntax, DSLStatement statement) throws ParsingException {
            super(ListComponentsOperation.NAME, syntax, statement);
            this.owner = statement.existsParameter("Owner") ? statement.getParameter("Owner").getValue() : null;
        }

        public Definition(String owner, String nodeName, EventScope eventScope, boolean isAll) {
            super(ListComponentsOperation.NAME, nodeName, eventScope, isAll);
            this.owner = owner;
        }

        public String getOwner() {
            return this.owner;
        }
    }
}

