/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.Collections;
import java.util.List;

public class ListComponentAccessorsOperation
extends AbstractNodeOperation {
    public static final String NAME = "list component accessors";

    public ListComponentAccessorsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST");
        this.syntax.setSubject((Subject)new Subject("COMPONENT").addParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("Component").setRequired(false)).addExclusionValue("ACCESSORS")));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ACCESSORS").setIncludeToDefinition(true)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Displays the resource Accessors currently opened into this component from other participants\n(e.g client applications, Triggers, Actors, Function or Services).\nThis command allows users to see who is accessing the component.\nIt may be used in combination with other commands to discover resource usage patterns.\n");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   <Component>    - Returns a list of component accessors opened into the specified component.\n                    This parameter must have the following format: <ComponentType>.<ComponentName>.\n   all            - Returns a list of all (system and non-system) component accessors.\n   at node <Node> - Returns a list of component accessors in the specified node.\n   at domain      - Returns a list of component accessors in the sysplex.");
        this.syntax.setExamples("list component accessors\nlist component accessors at node TestNode\nlist component accessors at domain\nlist component accessors all\nlist component accessors all at node TestNode\nlist component TSPACE.Test accessors\nlist component TSPACE.Test accessors at domain");
        this.syntax.addTag(OperationTag.accessor);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(ListComponentAccessorsOperation.getNodeName(statement), statement.existsParameter("Component") ? statement.getParameter("Component").getValue() : null, statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        List<AccessorSessionReference> sessions;
        Definition definition = (Definition)statement;
        if (definition.componentName != null) {
            ComponentReference component = ((RuntimeContext)this.callable).getModerator().getFabricNode().lookupComponent(definition.componentName);
            if (component == null) {
                throw new Exception("Component not found.");
            }
            sessions = component.getAccessorSessions(EventScope.INHERITED);
        } else {
            sessions = node.getAccessorSessions(EventScope.INHERITED);
        }
        Collections.sort(sessions);
        RowSet result = new RowSet(ListComponentAccessorsOperation.createResultDescriptor());
        for (AccessorSessionReference consumer : sessions) {
            if (!ListComponentAccessorsOperation.isAll(((Definition)statement).isAll, session) && ListComponentAccessorsOperation.isSystemComponent(consumer.getAccessorComponentName())) continue;
            ConsumerState state = consumer.getCurrentState();
            result.addToRowSet(new Object[]{node.getName(), ModeratorUtils.extractComponentName(ModeratorUtils.extractComponentNameFromConsumerName(consumer.getName())), consumer.getSessionName(), consumer.getAccessorComponentName(), consumer.getAccessorName(), consumer.getEventScope(), state != null ? state.getWorkingState().name() : "", state != null && state.getWorkingState() == ConsumerState.WorkingState.BUSY ? Long.toString(System.currentTimeMillis() - state.getStartTime()) : ""});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListComponentAccessorsOperation.addColumn(result, "Node");
        ListComponentAccessorsOperation.addColumn(result, "Component");
        ListComponentAccessorsOperation.addColumn(result, "Session");
        ListComponentAccessorsOperation.addColumn(result, "Accessor Component");
        ListComponentAccessorsOperation.addColumn(result, "Accessor");
        ListComponentAccessorsOperation.addColumn(result, "Scope");
        ListComponentAccessorsOperation.addColumn(result, "State");
        ListComponentAccessorsOperation.addColumn(result, "Time");
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private String componentName;
        private boolean isAll;

        public Definition(String nodeName, String componentName, boolean isAll) {
            super(ListComponentAccessorsOperation.NAME, nodeName);
            this.componentName = componentName;
            this.isAll = isAll;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public boolean isAll() {
            return this.isAll;
        }
    }
}

