/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListAccessorsOperation
extends AbstractNodeOperation {
    public static final String NAME = "list accessors";

    public ListAccessorsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ACCESSORS");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("AT COMPONENT", false).setSyntaxHintSpace()).addParameter((SyntaxParameter)new ExpressionParameter("Component").addExclusionValues("SHORT", "ALL", "*")));
        this.syntax.addModifier((AbstractModifier)new Modifier("SHORT", false).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Displays a general list of all open resource Accessors and their target components.\nThe list can be narrowed down to specific target components or expanded to show all Accessors across the domain.\nIt includes client applications, Triggers, Actors, Functions or Services\nand allows users to see what resources (components) a specific participant is accessing.\nNote: This is a reverse version of the LIST COMPONENT ACCESSORS command.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at <Component> - Returns a list of accessors opened by the specified component.\n                    This parameter must have the following format: <ComponentType>.<ComponentName>.\n   short          - Returns a list of available accessors in the short format.\n   all            - Returns a list of all (system and non-system) accessors.\n   at node <Node> - Returns a list of accessors in the specified node.\n   at domain      - Returns a list of accessors in the sysplex.");
        this.syntax.setExamples("list accessors\nlist accessors at node TestNode\nlist accessors at domain\nlist accessors short\nlist accessors short at domain\nlist accessors all\nlist accessors all at node TestNode\nlist accessors short all at domain\nlist accessors at component TSPACE.Test \nlist accessors at component TSPACE.Test at domain");
        this.syntax.addTag(OperationTag.accessor);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(ListAccessorsOperation.getNodeName(statement), statement.existsParameter("Component") ? statement.getParameter("Component").getValue() : null, statement.existsModifier("SHORT"), statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        SLResponse response = this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
        return !session.isInstant() && ((Definition)statement).isShort && response.getRowSet() != null ? this.processResponse(response) : response;
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        List<AccessorReference> accessors;
        Definition definition = (Definition)statement;
        if (definition.componentName != null) {
            ComponentReference component = ((RuntimeContext)this.callable).getModerator().getFabricNode().lookupComponent(definition.componentName);
            if (component == null) {
                throw new Exception("Component not found.");
            }
            accessors = component.getAccessors(EventScope.INHERITED);
        } else {
            accessors = node.getAccessors(EventScope.INHERITED);
        }
        Collections.sort(accessors);
        RowSet result = new RowSet(ListAccessorsOperation.createResultDescriptor(definition.isShort ? ResultType.SHORT : ResultType.STANDARD));
        for (AccessorReference accessor : accessors) {
            ComponentReference component = node.lookupComponent(accessor.getComponentAddress());
            if (component == null || !ListAccessorsOperation.isAll(definition.isAll, session) && ListAccessorsOperation.isSystemComponent(component.getName())) continue;
            if (definition.isShort) {
                if (!accessor.isAvailable()) continue;
                result.addToRowSet(new Object[]{accessor.getName(), accessor.getSession().getName()});
                continue;
            }
            result.addToRowSet(new Object[]{node.getName(), ModeratorUtils.extractComponentName(component.getName()), accessor.getAccessorName(), ListAccessorsOperation.makeComponentName(accessor, false), accessor.getComponentModel() != null ? accessor.getComponentModel() : "", accessor.getEventScope(), accessor.isAvailable(), ListAccessorsOperation.skipNull(accessor.getActualNodeName()), ListAccessorsOperation.skipNull(accessor.isAvailable() ? accessor.getSession().getSessionName() : null)});
        }
        return new SLResponse(result);
    }

    protected SLResponse processResponse(SLResponse response) throws Exception {
        RowSet rowSet = response.getRowSet();
        ArrayList<String> accessors = new ArrayList<String>();
        ArrayList<String> sessions = new ArrayList<String>();
        int maxLen = 0;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            String accessor = rowSet.getString(1);
            if (accessor.length() > maxLen) {
                maxLen = accessor.length();
            }
            accessors.add(accessor);
            sessions.add(rowSet.getString(2));
        }
        RowSet result = new RowSet(ListAccessorsOperation.createResultDescriptor(ResultType.SHORT_FINAL));
        for (int i = 0; i < accessors.size(); ++i) {
            String accessor = (String)accessors.get(i);
            result.addToRowSet(new Object[]{accessor + ListAccessorsOperation.getSpaces(accessor, maxLen) + " --> " + (String)sessions.get(i)});
        }
        return new SLResponse(result);
    }

    private static String getSpaces(String str, int maxLen) {
        char[] result = new char[maxLen - str.length()];
        Arrays.fill(result, ' ');
        return new String(result);
    }

    static String makeComponentName(AccessorReference accessor, boolean actual) {
        return actual ? ModeratorUtils.makeComponentFullName(accessor.getActualNodeName(), accessor.getComponentType(), accessor.getComponentName()) : ModeratorUtils.makeComponentFullName(accessor.getNodeName(), accessor.getComponentType(), accessor.getComponentName());
    }

    private static RowMetaData createResultDescriptor(ResultType resultType) {
        RowMetaData result = new RowMetaData();
        switch (resultType.ordinal()) {
            case 0: {
                ListAccessorsOperation.addColumn(result, "Node");
                ListAccessorsOperation.addColumn(result, "Component");
                ListAccessorsOperation.addColumn(result, "Accessor");
                ListAccessorsOperation.addColumn(result, "Accessed Component");
                ListAccessorsOperation.addColumn(result, "Model");
                ListAccessorsOperation.addColumn(result, "Scope");
                ListAccessorsOperation.addColumn(result, "Available");
                ListAccessorsOperation.addColumn(result, "Actual Node");
                ListAccessorsOperation.addColumn(result, "Session");
                break;
            }
            case 1: {
                ListAccessorsOperation.addColumn(result, "Accessor");
                ListAccessorsOperation.addColumn(result, "Session");
                break;
            }
            case 2: {
                ListAccessorsOperation.addColumn(result, "Accessor");
            }
        }
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private String componentName;
        private boolean isShort;
        private boolean isAll;

        public Definition(String nodeName, String componentName, boolean isShort, boolean isAll) {
            super(ListAccessorsOperation.NAME, nodeName);
            this.componentName = componentName;
            this.isShort = isShort;
            this.isAll = isAll;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public boolean isShort() {
            return this.isShort;
        }

        public boolean isAll() {
            return this.isAll;
        }
    }

    static enum ResultType {
        STANDARD,
        SHORT,
        SHORT_FINAL;

    }
}

