/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManager;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;

public class ListAccessPointsOperation
extends AbstractNodeOperation {
    public static final String NAME = "list access points";

    public ListAccessPointsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ACCESS POINTS");
        this.syntax.addModifier((AbstractModifier)new Modifier("PROTOCOL", false).addParameter(new EnumParameter("Protocol", Definition.Protocol.class)));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of active access points.");
        this.syntax.setSyntaxDescription("list access points                                    - Returns a list of all access points in the current node.\nlist access points at node <Node>                     - Returns a list of all access points in the specified node.\nlist access points at domain                          - Returns a list of all access points in the sysplex.\nlist access points protocol <Protocol>                - Returns a list of access points of the specified protocol in the current node.\nlist access points protocol <Protocol> at node <Node> - Returns a list of access points of the specified protocol in the specified node.\nlist access points protocol <Protocol> at domain      - Returns a list of access points of the specified protocol in the sysplex.");
        this.syntax.setExamples("list access points\nlist access points at node TestNode\nlist access points at domain\nlist access points protocol tlp\nlist access points protocol all at node TestNode\nlist access points protocol http at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition.Protocol protocol = statement.existsParameter("Protocol") ? Definition.Protocol.valueOf(statement.getParameter("Protocol").getValue().toUpperCase()) : Definition.Protocol.ALL;
        return new Definition(protocol, ListAccessPointsOperation.getNodeName(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListAccessPointsOperation.createResultDescriptor());
        AcceptorFactoryManager manager = ((RuntimeContext)this.callable).getAcceptorManager();
        for (String factoryName : manager.listRegisteredFactories()) {
            AcceptorFactory factory = manager.lookupFactory(factoryName);
            if (!this.match(factory.getAcceptorProtocol(), definition.protocol)) continue;
            for (Acceptor acceptor : factory.getAcceptors()) {
                this.addAcceptor(node, acceptor, result);
            }
            if (factory.getAcceptorProtocol() != LinkProtocol.HTTP) continue;
            this.addAcceptor(node, this.getAdminAcceptor(), result);
        }
        return new SLResponse(result);
    }

    private boolean match(LinkProtocol linkProtocol, Definition.Protocol protocol) {
        switch (protocol.ordinal()) {
            case 0: {
                return linkProtocol == LinkProtocol.TLP;
            }
            case 1: {
                return linkProtocol == LinkProtocol.HTTP;
            }
            case 2: {
                return linkProtocol == LinkProtocol.XMPP;
            }
            case 3: {
                return true;
            }
        }
        throw new RuntimeException("Invalid Definition.Protocol!");
    }

    private void addAcceptor(FabricNodeReference node, Acceptor acceptor, RowSet result) throws Exception {
        if (acceptor != null && acceptor.isStarted()) {
            LinkAddress address = acceptor.getAddress();
            result.addToRowSet(new Object[]{node.getName(), acceptor.getProtocol().name(), address.getAddress().getHostString(), address.getAddress().getPort(), this.isAdminAcceptor(acceptor)});
        }
    }

    private boolean isAdminAcceptor(Acceptor acceptor) {
        return acceptor instanceof HTTPAcceptor && ((HTTPAcceptor)acceptor).isAdmin();
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListAccessPointsOperation.addColumn(result, "Node");
        ListAccessPointsOperation.addColumn(result, "Protocol");
        ListAccessPointsOperation.addColumn(result, "Host");
        ListAccessPointsOperation.addColumn(result, "Port");
        ListAccessPointsOperation.addColumn(result, "Admin");
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private Protocol protocol;

        public Definition(Protocol protocol, String nodeName) {
            super(ListAccessPointsOperation.NAME, nodeName);
            this.protocol = protocol;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public static enum Protocol {
            TLP,
            HTTP,
            XMPP,
            ALL;

        }
    }
}

