/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;
import java.util.stream.Collectors;

public class KillNodeOperation<T extends RuntimeContext>
extends AbstractOperation<T> {
    public static final String NAME = "kill node";

    public KillNodeOperation(boolean mnode) {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("KILL NODE");
        if (mnode) {
            this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).setSyntaxHint(SyntaxHint.SPACE)).addModifier(new Modifier("RESTART"))).addModifier((AbstractModifier)new Modifier().addParameter(new IdentifierParameter("NodeName"))));
        } else {
            this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("NodeName").setRequired(false));
        }
        this.syntax.setDescription("Forcibly kills the specified node.\nThis operation is Platform-specific and may be unavailable in some environments.");
        this.syntax.setSyntaxDescription("kill node            - Kills the current node.\nkill node <NodeName> - Kills the specified node." + (mnode ? "\nkill node restart    - Kills the current node and then restarts it." : ""));
        this.syntax.addCompletionCommand("list nodes");
        this.syntax.addTag(OperationTag.moderator);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().listFabricNodes().stream().collect(Collectors.toList()));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NodeName").getValue(), statement.existsModifier("RESTART"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Pair<FabricNodeReference, Integer> nodeAndPid = this.lookupNodeAndPid(definition.nodeName);
        int pid = (Integer)nodeAndPid.second;
        if (pid == -1) {
            return new SLResponse("Process ID is not available.", false);
        }
        FabricNodeReference node = (FabricNodeReference)nodeAndPid.first;
        if (node != null && definition.restart) {
            if (node.getRole() != FabricNodeRole.MANAGEMENT_NODE) {
                return new SLResponse("Restart option is applicable for management nodes only.", false);
            }
            if (!node.isLocal()) {
                return new SLResponse("Restart option is applicable for local node only.", false);
            }
        }
        if (node != null && node.isLocal()) {
            FabricThreadManager.getInstance().createThread("EXCH:Kill.Node", "Kills the node '" + node.getName() + "'.", () -> {
                Utils.sleep(500L);
                if (definition.restart) {
                    this.onRestartNode();
                }
                this.executeCommand(definition.nodeName, pid);
            }).start();
            return new SLResponse();
        }
        return this.executeCommand(definition.nodeName, pid);
    }

    protected Pair<FabricNodeReference, Integer> lookupNodeAndPid(String nodeName) throws Exception {
        FabricNodeReference node = this.lookupNode(nodeName);
        if (node == null) {
            throw new FabricException("Node not found.");
        }
        return new Pair<FabricNodeReference, Integer>(node, node.getProcessID());
    }

    protected FabricNodeReference lookupNode(String nodeName) {
        return nodeName == null ? ((RuntimeContext)this.callable).getModerator().getFabricNode() : ((RuntimeContext)this.callable).getModerator().lookupFabricNode(nodeName);
    }

    protected void onRestartNode() {
    }

    private SLResponse executeCommand(String nodeName, int pid) {
        try {
            Utils.killProcess(pid);
            this.onKillNode(nodeName);
            return new SLResponse();
        }
        catch (Exception exception) {
            return new SLResponse("Operation failed: " + exception.toString(), false);
        }
    }

    protected void onKillNode(String nodeName) {
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private boolean restart;

        public Definition(String nodeName, boolean restart) {
            super(KillNodeOperation.NAME);
            this.nodeName = nodeName;
            this.restart = restart;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public boolean isRestart() {
            return this.restart;
        }
    }
}

