/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;

public class DropEventCacheOperation
extends AbstractModeratorOperation {
    public static final String NAME = "drop event cache";

    public DropEventCacheOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP EVENT CACHE").addActionParameter(new ExpressionParameter("EventFilter", '[', ']'));
        this.syntax.setDescription("Drops an existing event cache with specified event filter.");
        this.syntax.setExamples("drop event cache [event.cache1]");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("EventFilter").getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        connection.open();
        try (FabricConnection connection = new FabricConnectionFactory().createConnection();){
            connection.removeEventCache(((Definition)statement).getEventFilter());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String eventFilter;

        public Definition(String eventFilter) {
            super(DropEventCacheOperation.NAME);
            this.eventFilter = eventFilter;
        }

        public String getEventFilter() {
            return this.eventFilter;
        }
    }
}

