/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSysplexOperation
extends AbstractModeratorOperation {
    public static final String NAME = "describe sysplex";

    public DescribeSysplexOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SYSPLEX");
        this.syntax.setDescription("Shows information about the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        boolean security = ((RuntimeContext)this.callable).isSecurityEnabled();
        boolean presence = ((RuntimeContext)this.callable).isPresenceEnabled();
        boolean cluster = ((RuntimeContext)this.callable).isClustered();
        RowSet result = new RowSet(DescribeSysplexOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Domain", ((RuntimeContext)this.callable).getDomain()});
        result.addToRowSet(new Object[]{"UID", ((RuntimeContext)this.callable).getFabricUID()});
        result.addToRowSet(new Object[]{"Coherence", ((RuntimeContext)this.callable).isCoherenceAgentBound()});
        result.addToRowSet(new Object[]{"Security", ((RuntimeContext)this.callable).isSecurityEnabled()});
        if (((RuntimeContext)this.callable).isSecurityEnabled()) {
            result.addToRowSet(new Object[]{"Authentication Module", ((RuntimeContext)this.callable).getAuthenticationModuleFactory().getActiveModuleConfiguration().getName()});
            result.addToRowSet(new Object[]{"Anonymous Registration", ((RuntimeContext)this.callable).getExchange().anonymousRegistration()});
            result.addToRowSet(new Object[]{"Administrators", this.getAdministrators()});
        }
        result.addToRowSet(new Object[]{"Dataspace", ((RuntimeContext)this.callable).isDataspaceBound()});
        result.addToRowSet(new Object[]{"Presence", ((RuntimeContext)this.callable).isPresenceEnabled()});
        if (((RuntimeContext)this.callable).isClustered()) {
            result.addToRowSet(new Object[]{"Clusters", this.listClusters()});
        } else {
            result.addToRowSet(new Object[]{"Cluster", false});
        }
        result.addToRowSet(new Object[]{"Uptime", Utils.toTimeString(System.currentTimeMillis() - this.getStartTime())});
        result.addToRowSet(new Object[]{"Active Nodes", ((RuntimeContext)this.callable).getModerator().listFabricNodes().size()});
        result.addToRowSet(new Object[]{"Global Counter", ((RuntimeContext)this.callable).getExchange().showGlobalCounter()});
        return new SLResponse(result);
    }

    private List<String> getAdministrators() throws Exception {
        return ((RuntimeContext)this.callable).getSecurityManager().getUsers().stream().filter(User::isAdministrator).map(user -> user.getName().toString()).collect(Collectors.toList());
    }

    private long getStartTime() {
        long result = Long.MAX_VALUE;
        for (FabricNodeReference node : ((RuntimeContext)this.callable).getModerator().getFabricNodes()) {
            result = Math.min(result, node.getStartTime());
        }
        return result;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(12);
        DescribeSysplexOperation.addColumn(result, "Property");
        DescribeSysplexOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(DescribeSysplexOperation.NAME);
        }
    }
}

