/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.util.Collections;
import java.util.List;

public class DescribeProducerOperation
extends AbstractModeratorOperation {
    public static final String NAME = "describe producer";

    public DescribeProducerOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE PRODUCER").addActionParameter(new ExpressionParameter("ProducerName"));
        this.syntax.addModifier((AbstractModifier)new Modifier("EVENTS", false).setSyntaxHintSpace());
        this.syntax.setDescription("describe producer        - Shows information about the specified event producer.\ndescribe producer events - Shows information about all events bound to the specified event producer.");
        this.syntax.setSyntaxDescription("Parameter ComponentName must have the following format: [<NodeName>://]<ComponentType>.<ComponentName>");
        this.syntax.addCompletionCommand("list producers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ProducerName").getValue(), statement.existsModifier("EVENTS"));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            for (ComponentReference component : ((RuntimeContext)this.callable).getModerator().getComponents(EventScope.INHERITED)) {
                List<String> tokens;
                if (!component.hasBoundEventIds() || AbstractListEndpointsOperation.isSystemComponent((tokens = ModeratorUtils.splitComponentFullName(component.getName())).get(1), tokens.get(2))) continue;
                completions.add(component.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ComponentReference component = ((RuntimeContext)this.callable).getModerator().lookupComponent(((Definition)statement).getProducerName());
        return component != null && component.hasBoundEventIds() ? new SLResponse(DescribeProducerOperation.createResult(component, ((Definition)statement).events)) : new SLResponse("Producer not found.", false);
    }

    private static RowSet createResult(ComponentReference component, boolean events) throws Exception {
        RowSet result = new RowSet(DescribeProducerOperation.createResultDescriptor(events));
        List<String> eventIds = component.listBoundEventIds();
        if (events) {
            Collections.sort(eventIds);
            for (String eventId : eventIds) {
                result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventId)});
            }
        } else {
            List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
            result.addToRowSet(new Object[]{"Node", nameTokens.get(0)});
            result.addToRowSet(new Object[]{"Type", nameTokens.get(1)});
            result.addToRowSet(new Object[]{"Name", nameTokens.get(2)});
            result.addToRowSet(new Object[]{"Description", DescribeProducerOperation.skipNull(component.getDescription())});
            result.addToRowSet(new Object[]{"Model", component.getModel().toString()});
            result.addToRowSet(new Object[]{"Scope", component.getEventScope()});
            result.addToRowSet(new Object[]{"Address", component.getAddress()});
            result.addToRowSet(new Object[]{"Events", DescribeProducerOperation.formatEventIds(eventIds)});
        }
        return result;
    }

    private static RowMetaData createResultDescriptor(boolean events) {
        RowMetaData result = new RowMetaData();
        if (events) {
            DescribeProducerOperation.addColumn(result, "Event Id");
        } else {
            DescribeProducerOperation.addColumn(result, "Property");
            DescribeProducerOperation.addColumn(result, "Value");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String producerName;
        private boolean events = false;

        public Definition(String producerName, boolean events) {
            super(DescribeProducerOperation.NAME);
            this.producerName = producerName;
            this.events = events;
        }

        public String getProducerName() {
            return this.producerName;
        }

        public boolean isEvents() {
            return this.events;
        }
    }
}

