/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.NamedObjectComparator;
import com.streamscape.sef.container.ContainerLoggerParameters;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dispatcher.AbstractNodePropertiesOperation;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.mnode.MNodeContainer;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeNodeOperation
extends AbstractNodePropertiesOperation {
    public static final String NAME = "describe node";

    public DescribeNodeOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE NODE").addActionParameter((SyntaxParameter)new IdentifierParameter("NodeName").setRequired(false));
        this.syntax.setDescription("describe node            - Shows information about the current node.\ndescribe node <NodeName> - Shows information about the specified node.");
        this.syntax.addCompletionCommand("list nodes");
        this.setPreserveCompletionOrder();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("NodeName") ? statement.getParameter("NodeName").getValue() : null);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().getFabricNodes().stream().sorted(new NamedObjectComparator()).map(FabricNodeReference::getName).collect(Collectors.toList()));
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)definition).nodeName, definition, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement definition, AbstractMFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(DescribeNodeOperation.createResultDescriptor());
        DescribeNodeOperation.addValues(result, "Name", node.getName());
        DescribeNodeOperation.addValues(result, new Object[]{"Role", node.getRole()});
        DescribeNodeOperation.addValues(result, "Address", node.getFabricAddress());
        DescribeNodeOperation.addValues(result, "Weight", node.getWeight());
        DescribeNodeOperation.addValues(result, "Host", node.getInetAddress() != null ? node.getInetAddress().toString() : "n/a");
        DescribeNodeOperation.addValues(result, "PID", node.getProcessID() != -1 ? Integer.valueOf(node.getProcessID()) : "n/a");
        DescribeNodeOperation.addValues(result, "Current Time", DescribeNodeOperation.formatDate(new Date()));
        DescribeNodeOperation.addValues(result, "Time Zone", ((RuntimeContext)this.callable).getNodeTimezone().getID());
        DescribeNodeOperation.addValues(result, "Uptime", Utils.toTimeString(System.currentTimeMillis() - node.getStartTime()));
        DescribeNodeOperation.addValues(result, "Working Dir", new File(((RuntimeContext)this.callable).getStartupDir()).getPath().replace(File.separatorChar, '/'));
        File ddx = new File(((RuntimeContext)this.callable).getDeploymentDescriptorFilename()).getParentFile();
        if (ddx != null) {
            DescribeNodeOperation.addValues(result, "DDX Location", ddx.getCanonicalPath().replace(File.separatorChar, '/'));
        }
        this.addManagedBy(node, result);
        DescribeNodeOperation.addAcceptors(node.getAcceptors(), result);
        DescribeNodeOperation.addValues(result, "Coherence", DescribeNodeOperation.getStatus(((RuntimeContext)this.callable).isCoherenceAgentBound()));
        DescribeNodeOperation.addValues(result, "Dataspace", DescribeNodeOperation.getStatus(((RuntimeContext)this.callable).isDataspaceBound()));
        DescribeNodeOperation.addValues(result, "Presence", DescribeNodeOperation.getStatus(((RuntimeContext)this.callable).isPresenceEnabled()));
        DescribeNodeOperation.addValues(result, "Security", DescribeNodeOperation.getStatus(((RuntimeContext)this.callable).isSecurityEnabled()));
        DescribeNodeOperation.addValues(result, "Repository", DescribeNodeOperation.getStatus(((RuntimeContext)this.callable).isRepositoryBound()));
        if (((RuntimeContext)this.callable).isClustered()) {
            DescribeNodeOperation.addValues(result, "Cluster Name", ((RuntimeContext)this.callable).getClusterName());
        } else {
            DescribeNodeOperation.addValues(result, "Cluster", DescribeNodeOperation.getStatus(false));
        }
        DescribeNodeOperation.addValues(result, "Repository IO Timeout", this.getCacheIoTimeout());
        this.addLogProperties(result);
        this.addContainerProperties(result);
        DescribeNodeOperation.addValues(result, "Peer State", ((RuntimeContext)this.callable).getPeerState().name());
        DescribeNodeOperation.addValues(result, "Configuration State", ((RuntimeContext)this.callable).getConfigurationState().toString());
        return new SLResponse(result);
    }

    private void addManagedBy(FabricNodeReference node, RowSet result) {
        if (node.getRole() == FabricNodeRole.TASK_NODE) {
            String managedBy = "none";
            boolean isCheckoutCopy = false;
            ManagementNode mnode = this.getManagementNodeObject(node);
            if (mnode != null && mnode.getName() != null) {
                managedBy = mnode.getName();
                isCheckoutCopy = mnode.isCheckedOut();
            }
            DescribeNodeOperation.addValues(result, "Managed By", managedBy);
            DescribeNodeOperation.addValues(result, "Is Check-out Copy", isCheckoutCopy);
        }
    }

    private static String getStatus(boolean status) {
        return status ? "Enabled" : "Disabled";
    }

    private static void addAcceptors(List<LinkAddress> acceptors, RowSet result) throws Exception {
        ArrayList addresses = acceptors.stream().sorted().map(LinkAddress::toString).collect(Collectors.toCollection(ArrayList::new));
        DescribeNodeOperation.addValues(result, "Access Points", addresses);
    }

    private void addLogProperties(RowSet result) throws Exception {
        File log = TraceConfigurator.getInstance().getLogFile();
        if (log != null && log.exists()) {
            DescribeNodeOperation.addValues(result, "Log File", this.getPathRelativeToWorkingDir(log).toString().replace(File.separatorChar, '/'));
            DescribeNodeOperation.addValues(result, "Log File Size", AbstractOperation.Scale.KB.format(log.length()));
        }
    }

    private void addContainerProperties(RowSet result) throws Exception {
        FabricContainer container = ((RuntimeContext)this.callable).getContainer();
        if (container != null) {
            ContainerLoggerParameters logger = container.getLoggerParameters();
            if (logger != null) {
                DescribeNodeOperation.addValues(result, "Log File Max Size", AbstractOperation.Scale.KB.format(logger.getMaxSize()));
                DescribeNodeOperation.addValues(result, "Log File Archive", DescribeNodeOperation.getStatus(logger.isArchive()));
                DescribeNodeOperation.addValues(result, "Maximum Log Files", logger.getMaxFiles());
                DescribeNodeOperation.addValues(result, "Log ID Format", logger.isSequence() ? "sequence" : "timestamp");
                DescribeNodeOperation.addValues(result, "Log Generation", logger.getAdvisoryGeneration() >= 0 ? Integer.valueOf(logger.getAdvisoryGeneration()) : "n/a");
                DescribeNodeOperation.addValues(result, "Log Threshold", logger.getAdvisoryThreshold() > 0 ? logger.getAdvisoryThreshold() + "%" : "n/a");
            }
            if (container instanceof MNodeContainer) {
                MNodeContainer mNodeContainer = (MNodeContainer)container;
                String activatorUrl = mNodeContainer.getActivatorURL();
                DescribeNodeOperation.addValues(result, "Activator URL", activatorUrl != null ? activatorUrl : "n/a");
                DescribeNodeOperation.addValues(result, "Minimum TLP Port", mNodeContainer.getMinTlpPort());
                DescribeNodeOperation.addValues(result, "Maximum TLP Port", mNodeContainer.getMaxTlpPort());
                DescribeNodeOperation.addValues(result, "Minimum HTTP Port", mNodeContainer.getMinHttpPort());
                DescribeNodeOperation.addValues(result, "Maximum HTTP Port", mNodeContainer.getMaxHttpPort());
            }
        }
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeNodeOperation.addColumn(result, "Property");
        DescribeNodeOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(DescribeNodeOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

