/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEventCacheOperation
extends AbstractModeratorOperation {
    public static final String NAME = "describe event cache";

    public DescribeEventCacheOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE EVENT CACHE").addActionParameter(new ExpressionParameter("EventFilter", '[', ']'));
        this.syntax.setDescription("Shows information about the event cache for specified event filter.");
        this.syntax.setExamples("describe event cache [event.cache1]");
        this.syntax.addCompletionCommand("list event caches");
        this.setPreserveCompletionOrder();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("EventFilter").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().listEventCaches().stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        EventCacheReference cache = ((RuntimeContext)this.callable).getModerator().lookupEventCache(definition.getEventFilter());
        if (cache == null) {
            return new SLResponse("Event Cache not found.", false);
        }
        RowSet result = new RowSet(DescribeEventCacheOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Event Filter", StringUtils.wrapEventId(cache.getEventFilter())});
        result.addToRowSet(new Object[]{"Max Size", cache.getMaxSize()});
        result.addToRowSet(new Object[]{"Threshold Action", cache.getThresholdAction().name()});
        result.addToRowSet(new Object[]{"Current Size", cache.getSize()});
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeEventCacheOperation.addColumn(result, "Property");
        DescribeEventCacheOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        String eventFilter;

        public Definition(String eventFilter) {
            super(DescribeEventCacheOperation.NAME);
            this.eventFilter = eventFilter;
        }

        public String getEventFilter() {
            return this.eventFilter;
        }
    }
}

