/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.runtime.mf.operation.moderator.ListConsumersOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.enums.FlowControlMode;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.util.List;

public class DescribeConsumerOperation
extends AbstractModeratorOperation {
    public static final String NAME = "describe consumer";

    public DescribeConsumerOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE CONSUMER").addActionParameter(new ExpressionParameter("ConsumerName"));
        this.syntax.addModifier((AbstractModifier)new Modifier("EVENTS", false).setSyntaxHintSpace());
        this.syntax.setCompactSyntax("describe consumer <ConsumerName> [events]");
        this.syntax.setDescription("Shows information about the specified event consumer.\nParameter ConsumerName must have the following format: [<NodeName>://]<ComponentType>.<ComponentName>:<ConsumerName>");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   events - Shows information about all events of the event consumer.");
        this.syntax.setExamples("describe consumer TestNode://TestType.TestName:Test\ndescribe consumer TestNode://TestType.TestName:Test events");
        this.syntax.addTag(OperationTag.session);
        this.syntax.addCompletionCommand("list consumers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ConsumerName").getValue(), statement.existsModifier("EVENTS"));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            for (String consumer : ((RuntimeContext)this.callable).getModerator().listConsumers()) {
                List<String> tokens = ModeratorUtils.splitConsumerFullName(consumer);
                if (AbstractListEndpointsOperation.isSystemConsumer(tokens.get(1), tokens.get(2), tokens.get(3))) continue;
                completions.add(consumer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ConsumerReference consumer = ((RuntimeContext)this.callable).getModerator().lookupConsumer(((Definition)statement).getConsumerName());
        if (consumer != null && !ListConsumersOperation.checkSysadmin(consumer, ((RuntimeContext)this.callable).getModerator(), session)) {
            consumer = null;
        }
        return consumer != null ? new SLResponse(this.createResult(consumer, ((Definition)statement).events)) : new SLResponse("Consumer not found.", false);
    }

    private RowSet createResult(ConsumerReference consumer, boolean events) throws Exception {
        RowSet result = new RowSet(DescribeConsumerOperation.createResultDescriptor(events));
        if (events && consumer instanceof EventConsumerReference) {
            List<String> eventIds = AbstractListEndpointsOperation.getEventIds((EventConsumerReference)consumer);
            if (!eventIds.isEmpty()) {
                result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventIds.get(0)), DescribeConsumerOperation.skipNull(((EventConsumerReference)consumer).getEventSelector())});
                for (int i = 1; i < eventIds.size(); ++i) {
                    result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventIds.get(i)), ""});
                }
            }
        } else {
            DescribeConsumerOperation.addCommonRows(consumer, result);
            if (consumer instanceof AsyncConsumerReference) {
                DescribeConsumerOperation.addAsyncConsumerRows((AsyncConsumerReference)consumer, result);
            } else if (consumer instanceof DirectConsumerReference) {
                DescribeConsumerOperation.addEventConsumerFields((DirectConsumerReference)consumer, result);
            } else if (consumer instanceof ReceiverReference) {
                DescribeConsumerOperation.addReceiverFields((ReceiverReference)consumer, result);
            }
            ConsumerState state = consumer.getCurrentState();
            if (state != null) {
                result.addToRowSet(new Object[]{"State", state.getWorkingState()});
                if (state.getWorkingState() == ConsumerState.WorkingState.BUSY) {
                    result.addToRowSet(new Object[]{"Time", System.currentTimeMillis() - state.getStartTime()});
                }
            }
        }
        return result;
    }

    private static RowMetaData createResultDescriptor(boolean events) {
        RowMetaData result = new RowMetaData();
        if (events) {
            DescribeConsumerOperation.addColumn(result, "Event Id");
            DescribeConsumerOperation.addColumn(result, "Event Selector");
        } else {
            DescribeConsumerOperation.addColumn(result, "Property");
            DescribeConsumerOperation.addColumn(result, "Value");
        }
        return result;
    }

    private static void addAsyncConsumerRows(AsyncConsumerReference consumer, RowSet result) throws Exception {
        DescribeConsumerOperation.addEventConsumerFields(consumer, result);
        DescribeConsumerOperation.addCommonAsyncConsumerRows(consumer.getMaxDepth(), consumer.getCurrentDepth(), consumer.getFlowControlMode(), result);
        result.addToRowSet(new Object[]{"Delivery Mode", consumer.getDeliveryMode()});
        result.addToRowSet(new Object[]{"Delivery Spin Wait", consumer.getDeliverySpinWait()});
    }

    private static void addReceiverFields(ReceiverReference consumer, RowSet result) throws Exception {
        DescribeConsumerOperation.addEventConsumerFields(consumer, result);
        DescribeConsumerOperation.addCommonAsyncConsumerRows(consumer.getMaxDepth(), consumer.getCurrentDepth(), consumer.getFlowControlMode(), result);
    }

    private static void addCommonRows(ConsumerReference consumer, RowSet result) throws Exception {
        List<String> nameTokens = ModeratorUtils.splitConsumerFullName(consumer.getName());
        result.addToRowSet(new Object[]{"Node", nameTokens.get(0)});
        result.addToRowSet(new Object[]{"Component Type", nameTokens.get(1)});
        result.addToRowSet(new Object[]{"Component Name", nameTokens.get(2)});
        result.addToRowSet(new Object[]{"Consumer Name", nameTokens.get(3)});
        result.addToRowSet(new Object[]{"Mode", ModeratorUtils.getConsumerMode(consumer.getExchangeRole())});
        result.addToRowSet(new Object[]{"Scope", consumer.getEventScope()});
        result.addToRowSet(new Object[]{"Address", consumer.getAddress()});
    }

    private static void addEventConsumerFields(EventConsumerReference consumer, RowSet result) throws Exception {
        result.addToRowSet(new Object[]{"Events", String.valueOf(AbstractListEndpointsOperation.getEventIds(consumer)) + (String)(consumer.getEventSelector() != null ? " when (" + consumer.getEventSelector() + ")" : "")});
        result.addToRowSet(new Object[]{"No Local", consumer.noLocal()});
        result.addToRowSet(new Object[]{"Group", DescribeConsumerOperation.skipNull(consumer.getGroupName())});
    }

    private static void addCommonAsyncConsumerRows(int maxDepth, int currentDepth, FlowControlMode flowControlMode, RowSet result) throws Exception {
        result.addToRowSet(new Object[]{"Max Depth", maxDepth});
        if (currentDepth != -1) {
            result.addToRowSet(new Object[]{"Current Depth", currentDepth});
        }
        result.addToRowSet(new Object[]{"Flow Control Mode", flowControlMode});
    }

    public static class Definition
    extends AbstractSLStatement {
        private String consumerName;
        private boolean events = false;

        public Definition(String consumerName, boolean events) {
            super(DescribeConsumerOperation.NAME);
            this.consumerName = consumerName;
            this.events = events;
        }

        public String getConsumerName() {
            return this.consumerName;
        }

        public boolean isEvents() {
            return this.events;
        }
    }
}

