/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.ListComponentsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeComponentOperation
extends AbstractModeratorOperation {
    public static final String NAME = "describe component";

    public DescribeComponentOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE COMPONENT").addActionParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("ComponentName").addExclusionValues("A", "AC", "ACC", "ACCE", "ACCES", "ACCESS", "ACCESSO", "ACCESSOR")).setExcludedDelimiters("@="));
        this.syntax.addModifier((AbstractModifier)new Modifier("EVENTS", false).setSyntaxHintSpace());
        this.syntax.setDescription("describe component &lt;ComponentName&gt;        - Shows information about the specified component.\ndescribe component &lt;ComponentName&gt; events - Shows information about events of the specified component.\n\nParameter <i>ComponentName</i> must have the following format: [&lt;NodeName&gt;://]&lt;ComponentType&gt;.&lt;ComponentName&gt;");
        this.syntax.setExamples("describe component TestNode://Client_TLP.Example\ndescribe component TestNode://Client_TLP.Example events");
        this.syntax.addCompletionCommand("list components all");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (ComponentReference component : ((RuntimeContext)this.callable).getModerator().getComponents(EventScope.INHERITED)) {
            if (!DescribeComponentOperation.checkSysadmin(session, component)) continue;
            completions.add(component.getName());
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ComponentName").getValue(), statement.existsModifier("EVENTS"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        SecurityContext security;
        FabricNodeReference node;
        Definition definition = (Definition)statement;
        String nodeName = ModeratorUtils.extractNodeName(definition.componentName);
        FabricNodeReference fabricNodeReference = node = nodeName != null ? ((RuntimeContext)this.callable).getModerator().lookupFabricNode(nodeName) : ((RuntimeContext)this.callable).getModerator().getFabricNode();
        if (node == null) {
            throw new Exception("Node not found.");
        }
        ComponentReference component = node.lookupComponent(definition.componentName);
        SecurityContext securityContext = security = component != null ? component.getSecurityContext() : null;
        if (!ListComponentsOperation.checkSysadmin(session, security)) {
            component = null;
        }
        return component != null ? new SLResponse(definition.needEvents ? this.describeEvents(component) : this.describeCommon(session, component, security)) : new SLResponse("Component not found.", false);
    }

    private RowSet describeCommon(MFSession session, ComponentReference component, SecurityContext security) throws Exception {
        RowSet result = new RowSet(DescribeComponentOperation.createResultDescriptor());
        List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
        result.addToRowSet(new Object[]{"Node", nameTokens.get(0)});
        result.addToRowSet(new Object[]{"Type", nameTokens.get(1)});
        result.addToRowSet(new Object[]{"Name", nameTokens.get(2)});
        result.addToRowSet(new Object[]{"Description", DescribeComponentOperation.skipNull(component.getDescription())});
        result.addToRowSet(new Object[]{"Model", component.getModel().toString()});
        result.addToRowSet(new Object[]{"Scope", component.getEventScope()});
        result.addToRowSet(new Object[]{"Owner", security != null ? security.getOwnerName() : ""});
        result.addToRowSet(new Object[]{"Exception Strategy", component.getExceptionStrategy()});
        result.addToRowSet(new Object[]{"Address", component.getAddress()});
        result.addToRowSet(new Object[]{"Created On", DescribeComponentOperation.getCreationTime(component)});
        DescribeComponentOperation.addBoundEventIds(component.listBoundEventIds(), result);
        DescribeComponentOperation.addConsumers(component.listConsumers(), result);
        DescribeComponentOperation.addReplicationSources(component.listReplicationSources(), result);
        DescribeComponentOperation.addReplicationTargets(component.listReplicationTargets(), result);
        result.addToRowSet(new Object[]{"Fabric Groups", component.listGroups()});
        return result;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeComponentOperation.addColumn(result, "Property");
        DescribeComponentOperation.addColumn(result, "Value");
        return result;
    }

    private static void addBoundEventIds(List<String> eventIds, RowSet result) throws Exception {
        if (!eventIds.isEmpty()) {
            result.addToRowSet(new Object[]{"Bound Events", DescribeComponentOperation.formatEventIds(eventIds)});
        }
    }

    private static void addConsumers(List<String> consumers, RowSet result) throws Exception {
        DescribeComponentOperation.doAddConsumer(consumers, result, "Consumers");
    }

    private static void addReplicationSources(List<String> replicationSources, RowSet result) throws Exception {
        DescribeComponentOperation.doAddConsumer(replicationSources, result, "Replication Sources");
    }

    private static void addReplicationTargets(List<String> replicationTargets, RowSet result) throws Exception {
        DescribeComponentOperation.doAddConsumer(replicationTargets, result, "Replication Targets");
    }

    private static void doAddConsumer(List<String> consumers, RowSet result, String propertyName) throws Exception {
        List shortNames;
        if (!consumers.isEmpty() && !(shortNames = (List)consumers.stream().map(ModeratorUtils::extractConsumerName).filter(name -> !ReservedNames.isReserved(name)).sorted().collect(Collectors.toCollection(() -> new ArrayList(consumers.size())))).isEmpty()) {
            result.addToRowSet(new Object[]{propertyName, shortNames});
        }
    }

    private RowSet describeEvents(ComponentReference component) throws Exception {
        RowSet result = new RowSet(DescribeComponentOperation.createResultDescriptorForEvents());
        this.addOutboundEvents(component, result);
        this.addInboundEvents(component, result);
        return result;
    }

    private static RowMetaData createResultDescriptorForEvents() {
        RowMetaData result = new RowMetaData();
        DescribeComponentOperation.addColumn(result, "Event");
        DescribeComponentOperation.addColumn(result, "Event Model");
        DescribeComponentOperation.addColumn(result, "Type");
        DescribeComponentOperation.addColumn(result, "Consumer Name");
        DescribeComponentOperation.addColumn(result, "Event Filter");
        return result;
    }

    private void addOutboundEvents(ComponentReference component, RowSet result) throws Exception {
        for (String eventId : component.listBoundEventIds()) {
            Prototype prototype = ((RuntimeContext)this.callable).getDatagramPrototypeCache().lookupPrototype(eventId);
            if (prototype == null) continue;
            result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventId), prototype.getModelName(), "Producer", "-", "-"});
        }
    }

    private void addInboundEvents(ComponentReference component, RowSet result) throws Exception {
        for (EventConsumerReference consumer : component.getEventConsumers(EventScope.INHERITED)) {
            String consumerName = ModeratorUtils.extractConsumerName(consumer.getName());
            if (ReservedNames.isReserved(consumerName)) continue;
            List<String> eventIds = ((RuntimeContext)this.callable).getDatagramPrototypeCache().listEventIdsByFilter(new Filter(consumer.getEventFilter()));
            for (String eventId : eventIds) {
                Prototype prototype = ((RuntimeContext)this.callable).getDatagramPrototypeCache().lookupPrototype(eventId);
                if (prototype == null) continue;
                result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventId), prototype.getModelName(), "Consumer", consumerName, consumer.getEventFilter()});
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String componentName;
        private boolean needEvents;

        public Definition(String componentName, boolean needEvents) {
            super(DescribeComponentOperation.NAME);
            this.componentName = componentName;
            this.needEvents = needEvents;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public boolean needEvents() {
            return this.needEvents;
        }
    }
}

