/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.util.List;

public class DescribeComponentAccessorOperation
extends AbstractNodeOperation {
    public static final String NAME = "describe component accessor";

    public DescribeComponentAccessorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE COMPONENT ACCESSOR").addActionParameter(new ExpressionParameter("SessionName"));
        this.syntax.setDescription("Shows information about an accessor opened to the specified component.");
        this.syntax.setSyntaxDescription("The name must be in the following format: [<NodeName>://]<ComponentType>.<ComponentName>:<SessionName>");
        this.syntax.setExamples("describe component accessor TestNode://Client_TLP.Example:Session1");
        this.syntax.addCompletionCommand("list component accessors");
        this.syntax.addTag(OperationTag.accessor);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            for (String consumer : ((RuntimeContext)this.callable).getModerator().listAccessorSessions()) {
                List<String> tokens = ModeratorUtils.splitConsumerFullName(consumer);
                if (AbstractListEndpointsOperation.isSystemComponent(tokens.get(1), tokens.get(2))) continue;
                completions.add(consumer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("SessionName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AccessorSessionReference consumer = ((RuntimeContext)this.callable).getModerator().lookupAccessorSession(((Definition)statement).getSessionName());
        if (consumer == null) {
            return new SLResponse("Accessor session not found.", false);
        }
        RowSet result = new RowSet(DescribeComponentAccessorOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Node", ModeratorUtils.extractNodeName(consumer.getName())});
        result.addToRowSet(new Object[]{"Component", ModeratorUtils.extractComponentNameFromConsumerName(consumer.getName())});
        result.addToRowSet(new Object[]{"Session Name", consumer.getSessionName()});
        result.addToRowSet(new Object[]{"Accessor Component", consumer.getAccessorComponentName()});
        result.addToRowSet(new Object[]{"Accessor Name", consumer.getAccessorName()});
        result.addToRowSet(new Object[]{"SLANG Session", consumer.isSLSession()});
        result.addToRowSet(new Object[]{"Consumer Mode", "Request"});
        result.addToRowSet(new Object[]{"Event Scope", consumer.getEventScope()});
        result.addToRowSet(new Object[]{"Address", consumer.getAddress()});
        ConsumerState state = consumer.getCurrentState();
        if (state != null) {
            result.addToRowSet(new Object[]{"State", state.getWorkingState()});
            if (state.getWorkingState() == ConsumerState.WorkingState.BUSY) {
                result.addToRowSet(new Object[]{"Time", System.currentTimeMillis() - state.getStartTime()});
            }
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeComponentAccessorOperation.addColumn(result, "Property");
        DescribeComponentAccessorOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String sessionName;

        public Definition(String sessionName) {
            super(DescribeComponentAccessorOperation.NAME);
            this.sessionName = sessionName;
        }

        public String getSessionName() {
            return this.sessionName;
        }
    }
}

