/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.runtime.mf.operation.moderator.ListAccessorsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.util.Collections;
import java.util.List;

public class DescribeAccessorOperation
extends AbstractNodeOperation {
    public static final String NAME = "describe accessor";

    public DescribeAccessorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE ACCESSOR").addActionParameter(new ExpressionParameter("AccessorName"));
        this.syntax.addModifier((AbstractModifier)new Modifier("EVENTS", false).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Shows information about an accessor with the specified name.");
        this.syntax.setSyntaxDescription("The name must be in the following format: [<NodeName>://]<ComponentType>.<ComponentName>:<AccessorName>\n\nOptional parameters:\n\n   events - Shows information about all events bound to the specified accessor (accessor can raise these events).");
        this.syntax.setExamples("describe accessor TestNode://Client_TLP.Example:Accessor1");
        this.syntax.addCompletionCommand("list accessors");
        this.syntax.addTag(OperationTag.accessor);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            for (String consumer : ((RuntimeContext)this.callable).getModerator().listAccessors()) {
                List<String> tokens = ModeratorUtils.splitConsumerFullName(consumer);
                if (AbstractListEndpointsOperation.isSystemComponent(tokens.get(1), tokens.get(2))) continue;
                completions.add(consumer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("AccessorName").getValue(), statement.existsModifier("EVENTS"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        AccessorReference accessor = ((RuntimeContext)this.callable).getModerator().lookupAccessor(definition.accessorName);
        if (accessor == null) {
            return new SLResponse("Accessor not found.", false);
        }
        RowSet result = new RowSet(DescribeAccessorOperation.createResultDescriptor(definition.events));
        if (definition.events) {
            List<String> eventIds = accessor.listBoundEventIds();
            if (eventIds != null) {
                Collections.sort(eventIds);
                for (String eventId : eventIds) {
                    result.addToRowSet(new Object[]{eventId});
                }
            }
        } else {
            result.addToRowSet(new Object[]{"Node", ModeratorUtils.extractNodeName(accessor.getName())});
            result.addToRowSet(new Object[]{"Component", ModeratorUtils.extractComponentNameFromConsumerName(accessor.getName())});
            result.addToRowSet(new Object[]{"Accessor Name", accessor.getAccessorName()});
            result.addToRowSet(new Object[]{"Accessed Component", ListAccessorsOperation.makeComponentName(accessor, false)});
            result.addToRowSet(new Object[]{"Model", accessor.getComponentModel() != null ? accessor.getComponentModel() : ""});
            result.addToRowSet(new Object[]{"Scope", accessor.getEventScope()});
            result.addToRowSet(new Object[]{"Auto Switching", accessor.autoSwitching()});
            result.addToRowSet(new Object[]{"SLANG Session Name", DescribeAccessorOperation.skipNull(accessor.getSLSessionName())});
            result.addToRowSet(new Object[]{"Special SLANG Session", accessor.isSpecial()});
            result.addToRowSet(new Object[]{"Instant SLANG Session", accessor.isInstant()});
            result.addToRowSet(new Object[]{"State Listener", accessor.hasStateListener()});
            result.addToRowSet(new Object[]{"Available ", accessor.isAvailable()});
            result.addToRowSet(new Object[]{"Actual Node", DescribeAccessorOperation.skipNull(accessor.getActualNodeName())});
            result.addToRowSet(new Object[]{"Accessor Session", DescribeAccessorOperation.skipNull(accessor.isAvailable() ? accessor.getSession().getSessionName() : null)});
            List<String> events = accessor.listBoundEventIds();
            result.addToRowSet(new Object[]{"Events", events != null && !events.isEmpty()});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(boolean events) {
        RowMetaData result = new RowMetaData();
        if (events) {
            DescribeAccessorOperation.addColumn(result, "Event Id");
        } else {
            DescribeAccessorOperation.addColumn(result, "Property");
            DescribeAccessorOperation.addColumn(result, "Value");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String accessorName;
        private boolean events = false;

        public Definition(String accessorName, boolean events) {
            super(DescribeAccessorOperation.NAME);
            this.accessorName = accessorName;
            this.events = events;
        }

        public String getAccessorName() {
            return this.accessorName;
        }

        public boolean isEvents() {
            return this.events;
        }
    }
}

