/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;

public class CreateEventCacheOperation
extends AbstractModeratorOperation {
    public static final String NAME = "create event cache";

    public CreateEventCacheOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE EVENT CACHE").addActionParameter(new ExpressionParameter("EventFilter", '[', ']'));
        this.syntax.addModifier((AbstractModifier)new Modifier("MAX SIZE").addParameter(new IntegerParameter("MaxSize")));
        this.syntax.addModifier((AbstractModifier)new Modifier("THRESHOLD ACTION").addParameter(new EnumParameter("ThresholdAction", CacheThresholdAction.class)));
        this.syntax.setDescription("Creates a new event cache with specified event filter.");
        this.syntax.setSyntaxDescription("Mandatory parameters:\n\n   max size         - max size of a new event cache.\n   threshold action - threshold action of a new event cache.\n\n   Threshold action can be one of the following:\n\n      lre_discard - Least Recent Event will be discarded (oldest event will be removed from the Event Cache).\n      mre_discard - Most Recent Event will be discarded (new event won't be put to the Event Cache).\n\n   NOTE: Event filter is supposed to be simple which means that only '!','#' and '*' metacharacters are allowed.");
        this.syntax.setExamples("create event cache [event.cache1] max size 1000 threshold action LRE_DISCARD");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("EventFilter").getValue(), Integer.parseInt(statement.getParameter("MaxSize").getValue()), CacheThresholdAction.valueOf(statement.getParameter("ThresholdAction").getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        connection.open();
        try (FabricConnection connection = new FabricConnectionFactory().createConnection();){
            connection.addEventCache(definition.getEventFilter(), definition.getMaxSize(), definition.getCacheThresholdAction());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String eventFilter;
        private Integer maxSize;
        private CacheThresholdAction thresholdAction;

        public Definition(String eventFilter, Integer maxSize, CacheThresholdAction thresholdAction) {
            super(CreateEventCacheOperation.NAME);
            this.eventFilter = eventFilter;
            this.maxSize = maxSize;
            this.thresholdAction = thresholdAction;
        }

        public String getEventFilter() {
            return this.eventFilter;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public CacheThresholdAction getCacheThresholdAction() {
            return this.thresholdAction;
        }
    }
}

