/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.ConfigurationState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.File;

public class AlterSysplexDomainOperation
extends AbstractModeratorOperation {
    public static final String NAME = "alter sysplex domain";

    public AlterSysplexDomainOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER SYSPLEX DOMAIN").addActionParameter(new StringParameter("NewDomain"));
        this.syntax.setDescription("Alters the Sysplex domain.\nNode restart will be required after this operation.");
        this.syntax.addTag(OperationTag.sysplex);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("NewDomain").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        if (!((RuntimeContext)this.callable).getDomain().equals(((Definition)statement).domain)) {
            return this.invoke("*", statement, session, timeout, true, false);
        }
        return new SLResponse("The same domain, no changes required.");
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        File ddxLocation = DeployUtils.getDdxLocation((RuntimeContext)this.callable);
        CtxDeploymentDescriptor descriptor = DeployUtils.getDeploymentDescriptor(ddxLocation);
        descriptor.setReferral(((Definition)statement).domain);
        StDeployGenerator.generate(ddxLocation, descriptor);
        ((RuntimeContext)this.callable).setConfigurationState(ConfigurationState.RESTART_REQUIRED);
        return new SLResponse("Node restart required.");
    }

    static class Definition
    extends AbstractSLStatement {
        private String domain;

        Definition(String domain) {
            super(AlterSysplexDomainOperation.NAME);
            this.domain = domain;
        }
    }
}

