/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

abstract class AbstractListEndpointsOperation
extends AbstractNodeOperation {
    AbstractListEndpointsOperation(String name) {
        this.createDSLSyntax(name);
        this.setAction(name);
        this.addForModifier();
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.addModifier(new EventScopeModifier(false, EventScope.INHERITED));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL").setAlias("*")).setRequired(false));
        this.setCompactSyntax();
        String endpointsName = this.getEndpointName() + "s";
        this.syntax.setDescription("Returns a list of " + endpointsName + ".");
        this.syntax.setSyntaxDescription(this.getMainDescription(name, endpointsName) + "\nOptional parameters:\n\n   all                - Returns a list of all (system and non-system) " + endpointsName + ".\n   at node <NodeName> - Returns a list of " + endpointsName + " in the specified node.\n   at domain          - Returns a list of " + endpointsName + " in the sysplex.\n   event scope        - Specifies the event scope (OBSERVABLE, GLOBAL, CLUSTER)." + this.getForDescription(endpointsName));
        this.syntax.setExamples(name + "\n" + name + " all\n" + name + " at node Sample2\n" + name + " at domain all\n" + name + " event scope global" + this.getForExamples(name) + this.getSpecificExamples());
    }

    abstract String getEndpointName();

    void setAction(String name) {
        this.syntax.setAction(name.toUpperCase());
    }

    void addForModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR", false).setSyntaxHintSpace()).addParameter((SyntaxParameter)new EventIdParameter("EventId").setCompletionAdviser(new AbstractOperation.EventIdCompletionAdviser(this))));
    }

    void setCompactSyntax() {
    }

    String getForDescription(String endpointsName) {
        return "\n   for <EventId>      - Returns a list of " + endpointsName + " for the specified event.\n                        Parameter EventId should be put in [] characters.";
    }

    String getForExamples(String name) {
        return "\n" + name + " for [event.test]\n" + name + " for [event.test] all";
    }

    String getMainDescription(String name, String endpointsName) {
        return "Returns a list of non-system " + endpointsName + " in the current node.\n";
    }

    String getSpecificExamples() {
        return "";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.createDefinition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    static boolean isSystemConsumer(String componentType, String componentName, String consumerName) {
        return AbstractListEndpointsOperation.isSystemComponent(componentType, componentName) || componentType.equals("RuntimeContext") || ReservedNames.isReserved(consumerName);
    }

    List<ComponentReference> getComponents(EventScope eventScope) throws FabricException {
        return ((RuntimeContext)this.callable).getModerator().getFabricNode().getComponents(eventScope);
    }

    static List<String> getEventIds(EventConsumerReference consumer) {
        return StringUtils.split(consumer.getEventFilter(), '&');
    }

    abstract Definition createDefinition(DSLStatement var1) throws ParsingException;

    public static class Definition
    extends AbstractNodeOperation.Definition {
        protected EventScope eventScope;
        protected boolean isAll;

        Definition(String name, String nodeName, EventScope eventScope, boolean isAll) {
            super(name, nodeName);
            this.eventScope = eventScope;
            this.isAll = isAll;
        }

        Definition(String name, DSLStatementSyntax syntax, DSLStatement statement) throws ParsingException {
            super(name, AtNodeOrAtDomainModifier.getValue(statement));
            this.eventScope = EventScopeModifier.getValue(syntax, statement);
            this.isAll = statement.existsModifier("ALL");
        }

        public EventScope getEventScope() {
            return this.eventScope;
        }

        public boolean isAll() {
            return this.isAll;
        }
    }
}

