/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.mapper;

import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.mf.operation.mapper.AbstractMapperOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListSemanticMappersOperation
extends AbstractMapperOperation {
    public static final String NAME = "list semantic mappers";

    public ListSemanticMappersOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SEMANTIC MAPPERS");
        this.syntax.setDescription("Returns a list of semantic mappers in the node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListSemanticMappersOperation.createResultDescriptor());
        for (String mapper : SemanticMapRepositoryUtils.listSemanticMaps()) {
            result.addToRowSet(new Object[]{mapper});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListSemanticMappersOperation.addColumn(result, "Name");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListSemanticMappersOperation.NAME);
        }
    }
}

