/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.mapper;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.MappingObject;
import com.streamscape.omf.mapper.MappingRule;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.mapper.AbstractMapperOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.utils.StringUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSemanticMapperOperation
extends AbstractMapperOperation {
    public static final String NAME = "describe semantic mapper";

    public DescribeSemanticMapperOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SEMANTIC MAPPER").addActionParameter((SyntaxParameter)new IdentifierParameter("MapperName").setCompletionAdviser(new SemanticMapperCompletionAdviser()));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("SourcesTargetRules").addPossibleValues("RULES", "SOURCES", "TARGET").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Shows information about the specified semantic mapper.");
        this.syntax.setSyntaxDescription("describe semantic mapper <MapperName>         - Shows all information about semantic mapper except semantic rules.\ndescribe semantic mapper <MapperName> rules   - Shows semantic mapper rules.\ndescribe semantic mapper <MapperName> sources - Shows semantic mapper sources.\ndescribe semantic mapper <MapperName> target  - Shows semantic mapper target.\n");
        this.syntax.setExamples("describe semantic mapper Example");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("MapperName").getValue(), statement.getModifier("SourcesTargetRules").getToken());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SemanticMap mapper = SemanticMapRepositoryUtils.lookupSemanticMap(definition.mapperName);
        if (mapper == null) {
            throw new Exception("Semantic mapper doesn't exist.");
        }
        if ("RULES".equalsIgnoreCase(definition.rulesSourcesTarget)) {
            RowMetaData meta = new RowMetaData();
            DescribeSemanticMapperOperation.addColumn(meta, "Id");
            DescribeSemanticMapperOperation.addColumn(meta, "Rule");
            DescribeSemanticMapperOperation.addColumn(meta, "Comment");
            RowSet result = new RowSet(meta);
            int i = 0;
            for (MappingRule mappingRule : mapper.getMappingRules()) {
                result.addToRowSet(new Object[]{i++, mappingRule.getRule(), mappingRule.getComment() != null ? mappingRule.getComment() : ""});
            }
            return new SLResponse(result);
        }
        if ("SOURCES".equalsIgnoreCase(definition.rulesSourcesTarget)) {
            RowMetaData meta = this.createResultDescriptorSources();
            RowSet result = new RowSet(meta);
            for (MappingObject mappingObject : mapper.getSources()) {
                result.addToRowSet(new Object[]{this.getSemanticTypeName(mappingObject), mappingObject.getAlias() != null ? mappingObject.getAlias() : mappingObject.getSemanticType(), StringUtils.wrapEventId(mappingObject.getEventId())});
            }
            return new SLResponse(result);
        }
        if ("TARGET".equalsIgnoreCase(definition.rulesSourcesTarget)) {
            RowMetaData meta = this.createResultDescriptorSources();
            RowSet result = new RowSet(meta);
            if (mapper.getTarget() != null) {
                result.addToRowSet(new Object[]{mapper.getTarget().getSemanticType(), mapper.getTarget().getAlias() != null ? mapper.getTarget().getAlias() : mapper.getTarget().getSemanticType(), StringUtils.wrapEventId(mapper.getTarget().getEventId())});
            }
            return new SLResponse(result);
        }
        RowSet result = new RowSet(DescribeSemanticMapperOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Name", definition.mapperName});
        result.addToRowSet(new Object[]{"Validate Source", mapper.canValidateSource()});
        result.addToRowSet(new Object[]{"Validate Target", mapper.canValidateTarget()});
        result.addToRowSet(new Object[]{"Default Dataspace", mapper.getDefaultDataspace()});
        result.addToRowSet(new Object[]{"Version", mapper.getVersion()});
        return new SLResponse(result);
    }

    private Object getSemanticTypeName(MappingObject mappingObject) {
        if (mappingObject.getColumns() == null) {
            return mappingObject.getSemanticType();
        }
        return "ROW(" + mappingObject.getColumns().stream().map(column -> "name '" + column.getName() + "' type '" + column.getTypeName() + "'").collect(Collectors.joining(", ")) + ")";
    }

    private RowMetaData createResultDescriptorSources() {
        RowMetaData meta = new RowMetaData();
        DescribeSemanticMapperOperation.addColumn(meta, "Semantic Type");
        DescribeSemanticMapperOperation.addColumn(meta, "Alias");
        DescribeSemanticMapperOperation.addColumn(meta, "Event Id");
        return meta;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeSemanticMapperOperation.addColumn(result, "Property");
        DescribeSemanticMapperOperation.addColumn(result, "Value");
        return result;
    }

    public static class SemanticMapperCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                return SemanticMapRepositoryUtils.listSemanticMaps();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                return null;
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        String mapperName;
        String rulesSourcesTarget;

        public Definition(String mapperName, String rulesSourcesTarget) {
            super(DescribeSemanticMapperOperation.NAME);
            this.mapperName = mapperName;
            this.rulesSourcesTarget = rulesSourcesTarget;
        }
    }
}

