/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.mapper;

import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.omf.mapper.MappingObject;
import com.streamscape.omf.mapper.MappingRule;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.runtime.mf.operation.mapper.AbstractMapperOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CreateSemanticMapperOperation
extends AbstractMapperOperation {
    public static final String NAME = "create semantic mapper";

    public CreateSemanticMapperOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE SEMANTIC MAPPER").addActionParameter(new IdentifierParameter("MapperName"));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("SOURCES").addModifier(CreateSemanticMapperOperation.createSourcesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier(new Modifier("TARGET")).addModifier(new SetModifier("TARGETSET").addModifier(CreateSemanticMapperOperation.createSourcesTargetCompoundModifier("TargetCompound"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("RULES").addModifier(CreateSemanticMapperOperation.createRulesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("VALIDATE SOURCES").setName("ValidateSources")).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("VALIDATE TARGET").setName("ValidateTarget")).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DEFAULT DATASPACE").addParameter(new StringParameter("defaultDataspace"))).setRequired(false));
        this.syntax.setDescription("Creates semantic mapper.");
    }

    static RepeatableModifier createSourcesRepeatableModifier() {
        return (RepeatableModifier)new RepeatableModifier().addModifier(CreateSemanticMapperOperation.createSourcesTargetCompoundModifier("SourcesCompound"));
    }

    static CompoundModifier createSourcesTargetCompoundModifier(String name) {
        return new CompoundModifier(name).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(name + "CHOICE").addModifier((AbstractModifier)new Modifier("SEMANTIC TYPE").addParameter(new IdentifierParameter("semanticType")))).addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier("ROW_DEFINITION_COMP").setCompactSyntax("row(<name> <type>,...)")).setSyntaxHint(new SyntaxHint(" ", true))).addModifier(new Modifier("ROW")).addParameter(((ExpressionParameter)new ExpressionParameter("<name> <type>,...", '(', ')').setName("ROW_DEFINITION")).setIgnoreQuotes(false)))).addModifier((AbstractModifier)((Modifier)new Modifier("ALIAS").addParameter(new IdentifierParameter("alias"))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("EVENT ID").addParameter(new EventIdParameter("eventId"))).setRequired(false));
    }

    static RepeatableModifier createRulesRepeatableModifier() {
        return (RepeatableModifier)new RepeatableModifier().addModifier(new CompoundModifier("RulesCompound").addModifier((AbstractModifier)new Modifier("RULE").addParameter(new StringParameter("rule"))).addModifier((AbstractModifier)((Modifier)new Modifier("COMMENT").addParameter(new StringParameter("comment"))).setRequired(false)));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        SemanticMap semanticMap = new SemanticMap();
        String name = statement.getParameter("MapperName").getValue();
        if (SemanticMapRepositoryUtils.existsSemanticMap(name)) {
            throw new Exception("Semantic mapper with name '" + name + "' already exist.");
        }
        if (statement.existsBlock("SOURCES")) {
            semanticMap.setSources(CreateSemanticMapperOperation.getMappingObjectsFromBlock(session, statement, "SOURCES"));
        }
        if (statement.existsSet("TARGETSET")) {
            semanticMap.setTarget(CreateSemanticMapperOperation.getMappingObject(session, statement.getSet("TARGETSET").getElement(0)));
        }
        if (statement.existsBlock("RULES")) {
            semanticMap.setMappingRules(CreateSemanticMapperOperation.getMappingRulesObjectsFromBlock(statement, "RULES"));
        }
        semanticMap.setValidateSource(statement.existsModifier("ValidateSources"));
        semanticMap.setValidateTarget(statement.existsModifier("ValidateTarget"));
        if (statement.existsParameter("defaultDataspace")) {
            semanticMap.setDefaultDataspace(statement.getParameter("defaultDataspace").getValue());
        }
        SemanticMapRepositoryUtils.saveSemanticMap(name, semanticMap);
        return new SLResponse();
    }

    static List<MappingObject> getMappingObjectsFromBlock(MFSession session, DSLStatement statement, String name) {
        return new ArrayList<MappingObject>(statement.getBlock(name).getLines().stream().map(line -> CreateSemanticMapperOperation.getMappingObject(session, line)).collect(Collectors.toList()));
    }

    static List<MappingRule> getMappingRulesObjectsFromBlock(DSLStatement statement, String name) {
        return new ArrayList<MappingRule>(statement.getBlock(name).getLines().stream().map(line -> CreateSemanticMapperOperation.getMappingRule(line)).collect(Collectors.toList()));
    }

    static MappingObject getMappingObject(MFSession session, StatementValueList line) {
        MappingObject object = new MappingObject();
        if (line.existsParameter("semanticType")) {
            object.setSemanticType(line.getParameter("semanticType").getValue());
        } else {
            String rowDefinition = line.getParameter("ROW_DEFINITION").getValue();
            RowMetaData rowMetaData = CreateSemanticMapperOperation.parseRowDefinition(rowDefinition, (RuntimeMFSession)session);
            object.setColumns(rowMetaData.getColumnDescriptors());
            object.setSemanticType(Row.class.getSimpleName());
        }
        object.setAlias(line.getParameter("alias").getValue(null));
        object.setEventId(line.getParameter("eventId").getValue(null));
        return object;
    }

    public static RowMetaData parseRowDefinition(String rowDefinition, RuntimeMFSession session) {
        Scanner scanner = new Scanner("(" + rowDefinition + ")");
        scanner.scanNext();
        ParserDQL parser = new ParserDQL(session.getDataspaceSDSSession(), scanner);
        HashMappedList columnsList = parser.readRowDefinition();
        return Table.convertColumnListToRowMetaData(columnsList);
    }

    static MappingRule getMappingRule(StatementValueList line) {
        MappingRule rule = new MappingRule();
        rule.setRule(line.getParameter("rule").getValue());
        rule.setComment(line.getParameter("comment").getValue(null));
        return rule;
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(CreateSemanticMapperOperation.NAME);
            this.statement = statement;
        }
    }
}

