/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.mapper;

import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.mf.operation.mapper.AbstractMapperOperation;
import com.streamscape.runtime.mf.operation.mapper.CreateSemanticMapperOperation;
import com.streamscape.runtime.mf.operation.mapper.DescribeSemanticMapperOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.Comparator;

public class AlterSemanticMapperOperation
extends AbstractMapperOperation {
    public static final String NAME = "alter semantic mapper";

    public AlterSemanticMapperOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER SEMANTIC MAPPER").addActionParameter((SyntaxParameter)new IdentifierParameter("MapperName").setCompletionAdviser(new DescribeSemanticMapperOperation.SemanticMapperCompletionAdviser()));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("REMOVE SOURCES").addParameter(new SetParameter("RemoveSourceAliasesSet").addParameter(new IdentifierParameter("SourceAlias")))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((BlockModifier)new BlockModifier("ADD SOURCES").setName("AddSourcesBlock")).addModifier(CreateSemanticMapperOperation.createSourcesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((BlockModifier)new BlockModifier("SET SOURCES").setName("SetSourcesBlock")).addModifier(CreateSemanticMapperOperation.createSourcesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier(new Modifier("SET TARGET")).addModifier(new SetModifier("TARGETSET").addModifier(CreateSemanticMapperOperation.createSourcesTargetCompoundModifier("TargetCompound"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("REMOVE RULES").addParameter(new SetParameter("RemoveRuleIdsSet").addParameter(new IntegerParameter("RuleSequenceId")))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((BlockModifier)new BlockModifier("ADD RULES").setName("AddRulesBlock")).addModifier(CreateSemanticMapperOperation.createRulesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((BlockModifier)new BlockModifier("SET RULES").setName("SetRulesBlock")).addModifier(CreateSemanticMapperOperation.createRulesRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("VALIDATESOURCES").addPossibleValues("VALIDATE SOURCES", "NOT VALIDATE SOURCES").setRequired(false));
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("VALIDATETARGET").addPossibleValues("VALIDATE TARGET", "NOT VALIDATE TARGET").setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DEFAULT DATASPACE").addParameter(new StringParameter("defaultDataspace"))).setRequired(false));
        this.syntax.setDescription("Alters semantic mapper.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String name = statement.getParameter("MapperName").getValue();
        SemanticMap semanticMap = SemanticMapRepositoryUtils.lookupSemanticMap(name);
        if (semanticMap == null) {
            throw new Exception("Semantic mapper with name '" + name + "' already exist.");
        }
        if (statement.existsSet("RemoveSourceAliasesSet")) {
            statement.getSet("RemoveSourceAliasesSet").getElements().forEach(e -> semanticMap.removeSource(e.getParameter("SourceAlias").getValue()));
        }
        if (statement.existsBlock("AddSourcesBlock")) {
            semanticMap.addSources(CreateSemanticMapperOperation.getMappingObjectsFromBlock(session, statement, "AddSourcesBlock"));
        }
        if (statement.existsBlock("SetSourcesBlock")) {
            semanticMap.setSources(CreateSemanticMapperOperation.getMappingObjectsFromBlock(session, statement, "SetSourcesBlock"));
        }
        if (statement.existsSet("TARGETSET")) {
            semanticMap.setTarget(CreateSemanticMapperOperation.getMappingObject(session, statement.getSet("TARGETSET").getElement(0)));
        }
        if (statement.existsSet("RemoveRuleIdsSet")) {
            statement.getSet("RemoveRuleIdsSet").getElements().stream().map(e -> Integer.valueOf(e.getParameter("RuleSequenceId").getValue())).sorted(Comparator.reverseOrder()).forEach(id -> semanticMap.removeMappingRule((int)id));
        }
        if (statement.existsBlock("AddRulesBlock")) {
            semanticMap.addMappingRules(CreateSemanticMapperOperation.getMappingRulesObjectsFromBlock(statement, "AddRulesBlock"));
        }
        if (statement.existsBlock("SetRulesBlock")) {
            semanticMap.setMappingRules(CreateSemanticMapperOperation.getMappingRulesObjectsFromBlock(statement, "SetRulesBlock"));
        }
        if (statement.existsModifier("VALIDATE SOURCES")) {
            semanticMap.setValidateSource(true);
        } else if (statement.existsModifier("NOT VALIDATE SOURCES")) {
            semanticMap.setValidateSource(false);
        }
        if (statement.existsModifier("VALIDATE TARGET")) {
            semanticMap.setValidateTarget(true);
        } else if (statement.existsModifier("NOT VALIDATE TARGET")) {
            semanticMap.setValidateTarget(false);
        }
        if (statement.existsParameter("defaultDataspace")) {
            semanticMap.setDefaultDataspace(statement.getParameter("defaultDataspace").getValue());
        }
        semanticMap.setVersion(semanticMap.getVersion() + 1);
        SemanticMapRepositoryUtils.saveSemanticMap(name, semanticMap);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AlterSemanticMapperOperation.NAME);
            this.statement = statement;
        }
    }
}

