/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.keys;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.operation.http.ListWebApplicationsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSecurityKeysOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.sql.SQLException;

public class ListSecurityKeysOperation
extends AbstractSecurityKeysOperation {
    public static final String NAME = "list security keys";

    public ListSecurityKeysOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SECURITY KEYS");
        this.syntax.addModifier(new ListWebApplicationsOperation.AllOwnedByModifier());
        this.syntax.setDescription("Returns list of security keys. " + ListWebApplicationsOperation.AllOwnedByModifier.getDescription("security keys"));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getModifier("ALL").isPresent(), statement.getParameter("username").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.username == null) {
            definition.username = session.getOwnerName();
        }
        if (!session.getOwner().isAdministrator() && definition.username != null && !definition.username.equalsIgnoreCase(session.getOwnerName())) {
            throw new Exception("Non admin user can only see its own security keys.");
        }
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("Name", String.class).addColumn("UUID", String.class).addColumn("Algorithm", String.class).addColumn("Owner", String.class).addColumn("Is Public", String.class).addColumn("Created At", String.class).addColumn("Secret Key", String.class).addColumn("Private Key", String.class).addColumn("Public Key", String.class));
        this.getSecurityKeyStore().listEntries().stream().filter(e -> definition.all && (session.getOwner().isAdministrator() || e.isPublic()) || definition.username.equalsIgnoreCase(e.getOwnerName())).forEach(e -> {
            try {
                rowSet.addToRowSet(new Object[]{e.getName(), e.getUUID(), e.getAlgorithm().toString(), e.getOwnerName(), e.isPublic(), ListSecurityKeysOperation.formatDateMillis(e.getCreatedAt()), e.isSecretKeyPresent() ? "xxx" : "none", e.isPrivateKeyPresent() ? "xxx" : "none", e.isPublicKeyPresent() ? "xxx" : "none"});
            }
            catch (SQLException exception) {
                Trace.logException(this, exception, true);
            }
        });
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        boolean all = false;
        String username;

        public Definition(boolean all, String username) {
            super(ListSecurityKeysOperation.NAME);
            this.all = all;
            this.username = username;
        }
    }
}

