/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.keys;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityKeysOperation;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyStore;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;

public class DropSecurityKeyOperation
extends AbstractSecurityKeysOperation {
    public static final String NAME = "drop security key";

    public DropSecurityKeyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP SECURITY KEY");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("CH").addModifier((AbstractModifier)new Modifier("WITH UUID").addParameter(new StringParameter("uuid")))).addModifier((AbstractModifier)new Modifier("WITH NAME").addParameter(new StringParameter("name"))));
        this.syntax.addModifier((AbstractModifier)new Modifier("IF EXISTS").setRequired(false));
        this.syntax.setDescription("Drops specified security key.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("uuid").getValue(), statement.getParameter("name").getValue(), statement.existsModifier("IF EXISTS"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        SSSecurityKeyEntry entry;
        Definition definition = (Definition)statement;
        SSSecurityKeyStore store = this.getSecurityKeyStore();
        SSSecurityKeyEntry sSSecurityKeyEntry = entry = definition.name != null ? store.getEntryByName(definition.name) : store.getEntryByUUID(definition.uuid);
        if (entry == null) {
            if (definition.ifExists) {
                return new SLResponse();
            }
            throw new Exception("Specified security key doesn't exist.");
        }
        if (!session.getOwner().isAdministrator() && !session.getOwnerName().equalsIgnoreCase(entry.getOwnerName())) {
            throw new Exception("Non admin users can only remove its own security keys.");
        }
        store.deleteEntryByUUID(entry.getUUID());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private final String uuid;
        private final String name;
        private boolean ifExists;

        public Definition(String uuid, String name, boolean ifExists) {
            super(DropSecurityKeyOperation.NAME);
            this.uuid = uuid;
            this.name = name;
            this.ifExists = ifExists;
        }
    }
}

