/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.keys;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.network.http.server.authentication.jwt.JWT;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.StringParameter;

public class DescribeResourceTokenOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "describe resource token";

    public DescribeResourceTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.addTag(OperationTag.security);
        this.syntax.addTag(OperationTag.http);
        this.syntax.setAction("DESCRIBE RESOURCE TOKEN").addActionParameter(new StringParameter("token"));
        this.syntax.setDescription("Decodes and describes specified resource token.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("token").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        String token = ((Definition)definition).token;
        JWTDecodedToken decodedToken = JWT.decoder().decode(token);
        String signature = "OK";
        try {
            JWT.decoder().setContext((RuntimeContext)this.callable).verify(decodedToken);
        }
        catch (Exception exception) {
            signature = Utils.formatException(exception);
        }
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("Property", String.class).addColumn("Value", String.class));
        rowSet.addToRowSet(new Object[]{"Header", decodedToken.getHeaderJson()});
        rowSet.addToRowSet(new Object[]{"Payload", decodedToken.getPayloadJson()});
        rowSet.addToRowSet(new Object[]{"Expires At", decodedToken.getPayload().getExpiresAt() != null ? DescribeResourceTokenOperation.formatDate(decodedToken.getPayload().getExpiresAt() * 1000L) : "n/a"});
        rowSet.addToRowSet(new Object[]{"Issued At", decodedToken.getPayload().getIssuedAt() != null ? DescribeResourceTokenOperation.formatDate(decodedToken.getPayload().getIssuedAt() * 1000L) : "n/a"});
        rowSet.addToRowSet(new Object[]{"Not Before", decodedToken.getPayload().getNotBefore() != null ? DescribeResourceTokenOperation.formatDate(decodedToken.getPayload().getNotBefore() * 1000L) : "n/a"});
        rowSet.addToRowSet(new Object[]{"Signature", signature});
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String token;

        public Definition(String token) {
            super(DescribeResourceTokenOperation.NAME);
            this.token = token;
        }
    }
}

