/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.keys;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityKeysOperation;
import com.streamscape.sef.keys.SSSecurityKeyAlgorithm;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyGenerator;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class CreateSecurityKeyOperation
extends AbstractSecurityKeysOperation {
    public static final String NAME = "create security key";

    public CreateSecurityKeyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE SECURITY KEY").addActionParameter(new StringParameter("name"));
        this.syntax.addModifier((AbstractModifier)new Modifier("USING ALGORITHM").addParameter(new EnumParameter("alg", SSSecurityKeyAlgorithm.class)));
        this.syntax.addModifier((AbstractModifier)new Modifier("PUBLIC").setRequired(false));
        this.syntax.setDescription("Creates security key.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SSSecurityKeyAlgorithm.valueOf(statement.getParameter("alg").getValue().toUpperCase()), statement.getParameter("name").getValue(), statement.existsModifier("PUBLIC"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (this.getSecurityKeyStore().getEntryByName(definition.name) != null) {
            throw new Exception("Security key with specified name already exists.");
        }
        SSSecurityKeyEntry entry = SSSecurityKeyGenerator.algorithm(definition.algorithm).setName(definition.name).setCreatedAt(System.currentTimeMillis()).setOwnerName(session.getOwnerName()).setPublic(definition.isPublic).generate();
        this.getSecurityKeyStore().saveEntry(entry);
        return new SLResponse(entry.getUUID());
    }

    public static class Definition
    extends AbstractSLStatement {
        private final SSSecurityKeyAlgorithm algorithm;
        private final String name;
        private boolean isPublic;

        public Definition(SSSecurityKeyAlgorithm algorithm, String name, boolean isPublic) {
            super(CreateSecurityKeyOperation.NAME);
            this.algorithm = algorithm;
            this.name = name;
            this.isPublic = isPublic;
        }
    }
}

