/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.keys;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.keys.SSSecurityKeyEntryProviderNoKeys;
import com.streamscape.sef.network.http.server.authentication.jwt.JWT;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTPayload;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithmType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.parameter.TimeUnitParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AuthorizeResourceTokenOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "authorize resource token";

    public AuthorizeResourceTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.addTag(OperationTag.security);
        this.syntax.addTag(OperationTag.http);
        this.syntax.setAction("AUTHORIZE RESOURCE TOKEN");
        this.syntax.addModifier((AbstractModifier)new Modifier("CRYPTO").addParameter(new EnumParameter("alg", JWTAlgorithmType.class)));
        this.syntax.addModifier((AbstractModifier)new Modifier("KEY").addParameter((SyntaxParameter)new StringParameter("key name").setCompletionAdviser(new SecurityKeysNameCompletionAdviser())));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("EXPIRES_CHOICE").addModifier((AbstractModifier)new Modifier("EXPIRES ON").addParameter((SyntaxParameter)new StringParameter("expiration date").setName("expiresAt")))).addModifier((AbstractModifier)((Modifier)new Modifier("EXPIRES IN").addParameter((SyntaxParameter)new LongParameter("interval").setName("expiresIn"))).addParameter((SyntaxParameter)new TimeUnitParameter().setName("expiresInTimeUnit"))));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("VALID ON").addParameter(new StringParameter("validation date"))).setRequired(false));
        this.syntax.addModifier(new BlockModifier("RESOURCES").addModifier(AuthorizeResourceTokenOperation.createResourceRepeatableModifier()));
        this.syntax.setDescription("Creates a reusable, anonymous token for secure access to a specified resource. A resource is\na document or operation that is defined using standard URI scheme within the syseplex. It\nmay be a file stored in the file system, a File Object reference, an API end-point or a query\nend-point within a dataspace. See examples for ore detail.\n\nParameters:\n\n   crypto      - name of algorithm used to sign the token\n   key         - security Key name used to sign the token\n   expires on  - date when token expires in format yyyy-mm-dd hh:mm:ss.SSS\n   expires in  - expiration interval since creation\n   valid on    - date on which Token becomes valid in format yyyy-mm-dd hh:mm:ss.SSS\n   resources   - list of resources that can be accessed using the Token\n\nHTTP methods can be specified by adding them together, for example\n  - *        - any HTTP method\n  - POST     - only POST HTTP method\n  - GET|POST - only POST or GET HTTP methods\n\nURL mask has format like JAX-RS path templates. Common URL mask format: /segment1/segment2/....[/*].\nAllowed values for segments:\n  - mysegment                     - means segment with value 'mysegment'\n  - {somename}                    - means any segment\n  - {somename:regular expression} - means any segment that matches specified regular expression\n  - asterisk at the end           - means any segments at the end\n\nURL mask examples:\n  - /department/employees               - one URL /department/employees\n  - /department/employees/*             - any URL that starts with /department/employees/\n  - /department/{myanysegment}/projects - any URL that starts with /department, any second segment and third segment is projects\n  - /department/{c:\\d*}/projects       - any URL that starts with /department, second segment contains only digits and third segment is projects");
        this.syntax.setExamples("Resource token to download DropBox file, which expires in 10 days\n   authorize resource token crypto ecdsa512 key 'es512key' expires in 10 days resources(method 'GET' url 'dropbox/download/mydropbox/myfolder/myfile.txt')\nURL to download file using this token\n   GET /dropbox/download/d2/f2u/stquilt-dev.war?x-resource-token=....\n\nAlso DropBox download URL can be get using toDropBoxUrl function\n   toDropBoxUrl('mydropbox/myfolder/myfile.txt', 'Default', 'ecdsa512', 'es512key', null, '10 days', null)\n\nResource token to SELECT from the table\n   authorize resource token crypto ecdsa512 key 'es512key' expires in 10 days resources(method 'GET' url 'ds/tspace.myspace/mycollection')\nURL to SELECT using this token\n   GET ds/tspace.myspace/mycollection?*&responseFormat=html?x-resource-token=....\n\nResource token to INSERT into the table\n   authorize resource token crypto ecdsa512 key 'es512key' expires in 10 days resources(method 'POST' url 'ds/tspace.myspace/collection/mycollection')\n\nCurrenly there is only on URL to invoke all the services, so\nservices access can be restricted using API customizer.\n\nDownload FLOB as PDF\n   authorize resource token crypto ecdsa512 key 'es512key' expires in 10 days resources(method 'GET' url 'ds/TSPACE.MyFilesStorage/MyFilesStorage')\nURL using this token\n   GET /ds/TSPACE.MyDataspace/MyFilesStorage?flobColumn&where=id%3D1&responseFormat=pdf&responseMimeType=application/pdf\nTable access can be restricted using API customizer.\n");
    }

    static RepeatableModifier createResourceRepeatableModifier() {
        return (RepeatableModifier)new RepeatableModifier().addModifier(new CompoundModifier("RESOURCES_COMPOUND_MODIFIER").addModifier((AbstractModifier)new Modifier("METHOD").addParameter((SyntaxParameter)new StringParameter("http method mask").setName("method"))).addModifier((AbstractModifier)new Modifier("URL").addParameter((SyntaxParameter)new StringParameter("url mask").setName("url"))));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        JWTAlgorithmType algorithm = JWTAlgorithmType.valueOf(statement.getParameter("alg").getValue().toUpperCase());
        String securityKeyName = statement.getParameter("key name").getValue();
        Long expiresAt = null;
        if (statement.existsParameter("expiresAt")) {
            expiresAt = DataspaceDateTime.convertMillisToCalendar(DataspaceDateTime.getCalendar(), DataspaceDateTime.getSqlTimestampMilliseconds(statement.getParameter("expiresAt").getValue(), DataspaceDateTime.getTimezone().toString())) / 1000L;
        } else if (statement.existsParameter("expiresIn")) {
            Long expiresIn = TimeUnitParameter.parseValue(statement.getParameter("expiresInTimeUnit").getValue()).toSeconds(Long.valueOf(statement.getParameter("expiresIn").getValue()));
            expiresAt = System.currentTimeMillis() / 1000L + expiresIn;
        }
        Long notBefore = null;
        if (statement.existsParameter("validation date")) {
            notBefore = DataspaceDateTime.convertMillisToCalendar(DataspaceDateTime.getCalendar(), DataspaceDateTime.getSqlTimestampMilliseconds(statement.getParameter("validation date").getValue(), DataspaceDateTime.getTimezone().toString())) / 1000L;
        }
        List<JWTPayload.JWTResource> resources = AuthorizeResourceTokenOperation.getResources(statement);
        String token = JWT.builder().setKeyName(securityKeyName).setJwtAlgorithmType(algorithm).setContext((RuntimeContext)this.callable).setPayload(new JWTPayload().setIssuer(session.getOwnerName()).setExpiresAt(expiresAt).setNotBefore(notBefore).setResources(resources)).buildToken(session);
        return new SLResponse(token);
    }

    static List<JWTPayload.JWTResource> getResources(DSLStatement statement) {
        ArrayList<JWTPayload.JWTResource> resources = new ArrayList<JWTPayload.JWTResource>();
        StatementBlockValue block = statement.getBlock("RESOURCES");
        for (int i = 0; i < block.getLinesCount(); ++i) {
            StatementValueList line = block.getLineByIndex(i);
            resources.add(new JWTPayload.JWTResource(line.getParameter("method").getValue(), line.getParameter("url").getValue()));
        }
        return resources;
    }

    public static class SecurityKeysNameCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            return new SSSecurityKeyEntryProviderNoKeys(callable).listEntriesVisibleByUser(session.getOwnerName()).stream().map(e -> "'" + e.getName() + "'").collect(Collectors.toList());
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AuthorizeResourceTokenOperation.NAME);
            this.statement = statement;
        }
    }
}

