/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebApplicationOperation;
import com.streamscape.runtime.mf.operation.http.ListWebApplicationsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.sql.SQLException;
import java.util.List;

public class ListWebTokensOperation
extends AbstractWebOperation {
    public static final String NAME = "list web tokens";

    public ListWebTokensOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST WEB TOKENS");
        this.syntax.addModifier((AbstractModifier)new ListWebApplicationsOperation.AllOwnedByModifier().addModifier((AbstractModifier)new Modifier("FOR APPLICATION").addParameter((SyntaxParameter)new IdentifierParameter("ID").setCompletionAdviser(new DescribeWebApplicationOperation.ApplicationIdCompletionAdvisor()))));
        this.syntax.setDescription("Returns list of web tokens. " + ListWebApplicationsOperation.AllOwnedByModifier.getDescription("tokens"));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getModifier("ALL").isPresent(), statement.getParameter("username").getValue(), statement.getParameter("ID").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ApiKeyTokenService service = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyTokenService();
        Definition definition = (Definition)statement;
        return ListWebTokensOperation.getListTokens(definition.all ? "*" : definition.username, definition.applicationId, session, service);
    }

    public static SLResponse getListTokens(String username, String applicationId, MFSession session, ApiKeyTokenService service) throws SQLException {
        if (username == null || username.trim().length() == 0) {
            username = session.getOwner().getName().toString();
        }
        List<ApiKeyToken> tokens = service.getAll(username, null, applicationId);
        RowSet rowSet = new RowSet(ListWebTokensOperation.createResultDescriptor());
        for (ApiKeyToken token : tokens) {
            rowSet.addToRowSet(new Object[]{token.getName(), ListWebTokensOperation.formatDate(token.getCreatedAt()), token.getExtendPeriod() >= 0 ? ListWebTokensOperation.formatDate(token.getLastAccessedAt()) : "n/a", token.getExtendPeriod(), token.getExpiresIn(), token.getOwner(), token.getMasterNode(), token.getTokenId(), token.getApplicationId(), token.getDescription(), token.isGlobal()});
        }
        return new SLResponse(rowSet);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListWebTokensOperation.addColumn(result, "Name");
        ListWebTokensOperation.addColumn(result, "Created At");
        ListWebTokensOperation.addColumn(result, "Last Accessed At");
        ListWebTokensOperation.addColumn(result, "Extend Period");
        ListWebTokensOperation.addColumn(result, "Expires In");
        ListWebTokensOperation.addColumn(result, "Owner");
        ListWebTokensOperation.addColumn(result, "Master Node");
        ListWebTokensOperation.addColumn(result, "Token Id");
        ListWebTokensOperation.addColumn(result, "Application Id");
        ListWebTokensOperation.addColumn(result, "Description");
        ListWebTokensOperation.addColumn(result, "Global");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        boolean all = false;
        String username;
        private String applicationId;

        public Definition(boolean all, String username, String applicationId) {
            super(ListWebTokensOperation.NAME);
            this.all = all;
            this.username = username;
            this.applicationId = applicationId;
        }
    }
}

