/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebApplicationOperation;
import com.streamscape.runtime.mf.operation.http.ListWebApplicationsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class ListWebResourcesOperation
extends AbstractWebOperation {
    public static final String NAME = "list web resources";

    public ListWebResourcesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST WEB RESOURCES");
        this.syntax.addModifier((AbstractModifier)new ListWebApplicationsOperation.AllOwnedByModifier().addModifier((AbstractModifier)new Modifier("FOR APPLICATION").addParameter((SyntaxParameter)new IdentifierParameter("ID").setCompletionAdviser(new DescribeWebApplicationOperation.ApplicationIdCompletionAdvisor()))));
        this.syntax.setDescription("Returns list of web resources for specified applications with their application names.\n" + ListWebApplicationsOperation.AllOwnedByModifier.getDescription("resources"));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getModifier("ALL").isPresent(), statement.getParameter("username").getValue(), statement.getParameter("ID").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        List<Application> applications;
        RowSet rowSet = new RowSet(ListWebResourcesOperation.createResultDescriptor());
        ApplicationService service = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApplicationService();
        if (((Definition)statement).applicationId == null) {
            String username = ((Definition)statement).username;
            if (((Definition)statement).all) {
                username = "*";
            }
            if (username == null) {
                username = session.getOwnerName();
            }
            applications = service.getAll(username, null, true, true);
        } else {
            Application application2 = service.get(((Definition)statement).applicationId, true);
            if (application2 == null) {
                throw new Exception("Application with ID '" + ((Definition)statement).applicationId + "' doesn't exist.");
            }
            applications = Arrays.asList(application2);
        }
        applications.forEach(application -> application.getResources().forEach(resource -> {
            try {
                rowSet.addToRowSet(new Object[]{resource.getMethod(), resource.getUrl(), resource.getName() != null ? resource.getName() : "", resource.getDescription() != null ? resource.getDescription() : "", application.getName(), application.getApplicationId()});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        }));
        return new SLResponse(rowSet);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListWebResourcesOperation.addColumn(result, "HTTP Method Mask");
        ListWebResourcesOperation.addColumn(result, "URL Mask");
        ListWebResourcesOperation.addColumn(result, "Resource Name");
        ListWebResourcesOperation.addColumn(result, "Resource Description");
        ListWebResourcesOperation.addColumn(result, "Application Name");
        ListWebResourcesOperation.addColumn(result, "Application Id");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        boolean all = false;
        String username;
        private String applicationId;

        public Definition(boolean all, String username, String applicationId) {
            super(ListWebResourcesOperation.NAME);
            this.all = all;
            this.username = username;
            this.applicationId = applicationId;
        }
    }
}

