/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.acceptor.AlterAcceptorOperation;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

public class ListWebApplicationsOperation
extends AbstractWebOperation {
    public static final String NAME = "list web applications";

    public ListWebApplicationsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST WEB APPLICATIONS");
        this.syntax.addModifier(new AllOwnedByModifier());
        this.syntax.setDescription("Returns list of web applications. " + AllOwnedByModifier.getDescription("applications"));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getModifier("ALL").isPresent(), statement.getParameter("username").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ApplicationService service = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApplicationService();
        String username = ((Definition)statement).username;
        if (((Definition)statement).all) {
            username = "*";
        }
        if (username == null) {
            username = session.getOwnerName();
        }
        List<Application> applications = service.getAll(username, null, false, true);
        RowSet rowSet = new RowSet(ListWebApplicationsOperation.createResultDescriptor());
        for (Application a : applications) {
            rowSet.addToRowSet(new Object[]{a.getName(), ListWebApplicationsOperation.formatDate(a.getCreatedAt()), a.getOwner(), a.getMasterNode(), a.getApplicationId(), a.getDescription() != null ? a.getDescription() : "", a.isGlobal()});
        }
        return new SLResponse(rowSet);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListWebApplicationsOperation.addColumn(result, "Name");
        ListWebApplicationsOperation.addColumn(result, "Created At");
        ListWebApplicationsOperation.addColumn(result, "Owner");
        ListWebApplicationsOperation.addColumn(result, "Master Node");
        ListWebApplicationsOperation.addColumn(result, "Application Id");
        ListWebApplicationsOperation.addColumn(result, "Description");
        ListWebApplicationsOperation.addColumn(result, "Global");
        return result;
    }

    public static class AllOwnedByModifier
    extends ChoiceModifier {
        public AllOwnedByModifier() {
            super("AllOwnedByModifier");
            this.setSyntaxHint(SyntaxHint.SPACE);
            this.addModifier(new Modifier("ALL"));
            this.addModifier((AbstractModifier)new Modifier("OWNED BY").addParameter((SyntaxParameter)new IdentifierParameter("username").setCompletionAdviser(new AlterAcceptorOperation.UserCompletionAdviser())));
            this.setRequired(false);
        }

        public static String getDescription(String name) {
            return "By default returns all " + name + " owned by the current user.\n\nOptional parameters:\n  all                  - returns list of all " + name + " visible to the current user\n  owned by <username>' - returns all " + name + " owned by the specified user and visible to the current user";
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        boolean all = false;
        String username;

        public Definition(boolean all, String username) {
            super(ListWebApplicationsOperation.NAME);
            this.all = all;
            this.username = username;
        }
    }
}

