/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.AlterWebTokenOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebTokenOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DropWebTokenOperation
extends AbstractWebOperation {
    public static final String NAME = "drop web token";

    public DropWebTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP WEB TOKEN").addModifier(DescribeWebTokenOperation.createTokenIdNameOwnerModifier("Token", AlterWebTokenOperation::new));
        this.syntax.setDescription("Drops the specified web token.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractWebOperation.IdNameOwnerDefinition.parse(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ApiKeyToken apiKeyToken = DescribeWebTokenOperation.getApiKeyToken((RuntimeContext)this.callable, session, ((Definition)statement).idNameOwner);
        if (apiKeyToken == null) {
            throw new Exception("Token not found.");
        }
        int count = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyTokenService().revoke(apiKeyToken.getTokenId());
        if (count == 0) {
            throw new Exception("Token not found.");
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        AbstractWebOperation.IdNameOwnerDefinition idNameOwner;

        public Definition(AbstractWebOperation.IdNameOwnerDefinition idNameOwner) {
            super(DropWebTokenOperation.NAME);
            this.idNameOwner = idNameOwner;
        }
    }
}

