/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebApplicationOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DropWebApplicationOperation
extends AbstractWebOperation {
    public static final String NAME = "drop web application";

    public DropWebApplicationOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP WEB APPLICATION").addModifier(DescribeWebApplicationOperation.createApplicationIdNameOwnerModifier("Application", DropWebApplicationOperation::new));
        this.syntax.setDescription("Drops specified web application.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractWebOperation.IdNameOwnerDefinition.parse(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Application application = DescribeWebApplicationOperation.getApplication((RuntimeContext)this.callable, session, ((Definition)statement).idNameOwner, false);
        int count = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApplicationService().delete(application.getApplicationId());
        if (count == 0) {
            throw new Exception("Specified application not found.");
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        AbstractWebOperation.IdNameOwnerDefinition idNameOwner;

        public Definition(AbstractWebOperation.IdNameOwnerDefinition idNameOwner) {
            super(DropWebApplicationOperation.NAME);
            this.idNameOwner = idNameOwner;
        }
    }
}

