/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DescribeWebTokenOperation
extends AbstractWebOperation {
    public static final String NAME = "describe web token";

    public DescribeWebTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE WEB TOKEN").addModifier(DescribeWebTokenOperation.createTokenIdNameOwnerModifier("Token", DescribeWebTokenOperation::new));
        this.syntax.addModifier((AbstractModifier)new Modifier("BINDINGS").setRequired(false));
        this.syntax.setDescription("Describes web token.");
    }

    static CompoundModifier createTokenIdNameOwnerModifier(String name, Supplier<AbstractWebOperation> syntaxSuplier) {
        return new CompoundModifier("WITH_COMPOUND").addModifier(new Modifier("WITH")).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("WITH_CHOICE").addModifier((AbstractModifier)new Modifier("ID").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "ID").setName("ID1")).setCompletionAdviser(new TokenIdCompletionAdvisor())))).addModifier(new CompoundModifier("NAME_OWNER_COMPOUND").addModifier((AbstractModifier)new Modifier("NAME").addParameter((SyntaxParameter)((StringParameter)new StringParameter(name + "Name").setName("Name")).setCompletionAdviser(new TokenNameCompletionAdvisor(null)))).addModifier((AbstractModifier)((Modifier)new Modifier("OWNED BY").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "Owner").setName("Owner")).setCompletionAdviser(new TokenOwnerCompletionAdvisor(syntaxSuplier)))).setRequired(false)))).addModifier(new CompoundModifier("OWNER_NAME_COMPOUND").addModifier((AbstractModifier)new Modifier("OWNER", "OWNER1").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "Owner").setName("Owner1")).setCompletionAdviser(new TokenOwnerCompletionAdvisor(null)))).addModifier((AbstractModifier)new Modifier("NAME", "NAME1").addParameter((SyntaxParameter)((StringParameter)new StringParameter(name + "Name").setName("Name1")).setCompletionAdviser(new TokenNameCompletionAdvisor(syntaxSuplier))))));
    }

    static ApiKeyToken getApiKeyToken(RuntimeContext callable, MFSession session, AbstractWebOperation.IdNameOwnerDefinition idNameOwner) throws Exception {
        ApiKeyToken token = null;
        if (idNameOwner.id != null) {
            token = DescribeWebTokenOperation.getHTTPAuthenticationManager(callable, session).getApiKeyServiceFactory().getApiKeyTokenService().get(idNameOwner.id);
            if (token == null) {
                throw new Exception("Token with specified ID not found.");
            }
        } else if (idNameOwner.name != null) {
            List<ApiKeyToken> tokens;
            String owner = "*";
            if (idNameOwner.owner != null && idNameOwner.owner.length() > 0) {
                owner = idNameOwner.owner;
            }
            if ((tokens = DescribeWebTokenOperation.getHTTPAuthenticationManager(callable, session).getApiKeyServiceFactory().getApiKeyTokenService().getAll(owner, idNameOwner.name)) == null || tokens.size() == 0) {
                if (idNameOwner.owner == null) {
                    throw new Exception("Token with specified name not found.");
                }
                throw new Exception("Token with specified name and owner not found.");
            }
            if (tokens.size() > 1) {
                throw new Exception("More than one tokens with specified name found. Please specify token owner or token ID.");
            }
            token = tokens.get(0);
        }
        return token;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractWebOperation.IdNameOwnerDefinition.parse(statement), statement.getParameter("TokenId").getValue(), statement.getModifier("BINDINGS").isPresent());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ApiKeyToken token = DescribeWebTokenOperation.getApiKeyToken((RuntimeContext)this.callable, session, definition.idNameOwner);
        RowSet rowSet = null;
        if (definition.bindings) {
            rowSet = new RowSet(this.createResultDescriptorBindings());
            if (token.getSecurityBindings() != null) {
                Map<ApiKeySecurityBinding, String> values = token.getSecurityBindingsValues();
                for (ApiKeySecurityBinding binding : token.getSecurityBindings()) {
                    String value;
                    String string = value = values != null ? (String)values.getOrDefault((Object)binding, null) : null;
                    if (value == null) {
                        value = "";
                    }
                    rowSet.addToRowSet(new Object[]{binding.toString(), value});
                }
            }
        } else {
            rowSet = new RowSet(DescribeWebTokenOperation.createResultDescriptorProperties());
            rowSet.addToRowSet(new Object[]{"Name", token.getName()});
            rowSet.addToRowSet(new Object[]{"Description", token.getDescription()});
            rowSet.addToRowSet(new Object[]{"Token Id", token.getTokenId()});
            rowSet.addToRowSet(new Object[]{"Application Id", token.getApplicationId()});
            rowSet.addToRowSet(new Object[]{"Owner", token.getOwner()});
            rowSet.addToRowSet(new Object[]{"Master Node", token.getMasterNode()});
            rowSet.addToRowSet(new Object[]{"Created At", DateParameter.formatDate(token.getCreatedAt())});
            rowSet.addToRowSet(new Object[]{"Last Accessed At", token.getExtendPeriod() > 0 ? DateParameter.formatDate(token.getLastAccessedAt()) : "n/a"});
            rowSet.addToRowSet(new Object[]{"Extend Period(seconds)", token.getExtendPeriod()});
            rowSet.addToRowSet(new Object[]{"Expires In(seconds)", token.getExpiresIn()});
            rowSet.addToRowSet(new Object[]{"Timeout Before Deletion", token.getDeleteTimeoutAfterExpiration()});
            rowSet.addToRowSet(new Object[]{"Last Updated At", DateParameter.formatDate(token.getLastAccessedAt())});
            rowSet.addToRowSet(new Object[]{"Expires At", token.getExpiresIn() > 0 ? DateParameter.formatDate(token.getLastAccessedAt() + (long)(token.getExpiresIn() * 1000)) : "never"});
            rowSet.addToRowSet(new Object[]{"Global", token.isGlobal()});
        }
        return new SLResponse(rowSet);
    }

    private RowMetaData createResultDescriptorBindings() {
        RowMetaData result = new RowMetaData(10);
        DescribeWebTokenOperation.addColumn(result, "Binding");
        DescribeWebTokenOperation.addColumn(result, "Value");
        return result;
    }

    static RowMetaData createResultDescriptorProperties() {
        RowMetaData result = new RowMetaData(10);
        DescribeWebTokenOperation.addColumn(result, "Property");
        DescribeWebTokenOperation.addColumn(result, "Value");
        return result;
    }

    static class TokenIdCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        TokenIdCompletionAdvisor() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            return callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApiKeyTokenService().listTokens();
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class TokenNameCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        private Supplier<AbstractWebOperation> syntaxSupplier;
        private AbstractWebOperation operation;

        public TokenNameCompletionAdvisor(Supplier<AbstractWebOperation> syntaxSupplier) {
            this.syntaxSupplier = syntaxSupplier;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ApiKeyTokenService service = callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApiKeyTokenService();
            String user = null;
            if (this.syntaxSupplier != null) {
                if (this.operation == null) {
                    this.operation = this.syntaxSupplier.get();
                }
                try {
                    user = this.operation.parseDsl(processedScript + " ''").getParameter("Owner1").getValue(null);
                }
                catch (ParsingException exception) {
                    return new ArrayList<String>();
                }
            }
            if (user == null) {
                user = "*";
            }
            return new ArrayList<String>(service.getAll(user, null).stream().map(a -> "'" + a.getName() + "'").collect(Collectors.toSet()));
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class TokenOwnerCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        private Supplier<AbstractWebOperation> syntaxSupplier;
        private AbstractWebOperation operation;

        public TokenOwnerCompletionAdvisor(Supplier<AbstractWebOperation> syntaxSupplier) {
            this.syntaxSupplier = syntaxSupplier;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ApiKeyTokenService service = callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApiKeyTokenService();
            String tokenName = null;
            if (this.syntaxSupplier != null) {
                if (this.operation == null) {
                    this.operation = this.syntaxSupplier.get();
                }
                try {
                    tokenName = this.operation.parseDsl(processedScript + " user").getParameter("Name").getValue(null);
                }
                catch (ParsingException exception) {
                    return new ArrayList<String>();
                }
            }
            return service.getAll("*", tokenName).stream().map(a -> a.getOwner()).collect(Collectors.toList());
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private AbstractWebOperation.IdNameOwnerDefinition idNameOwner;
        private String tokenId;
        private boolean bindings;

        public Definition(AbstractWebOperation.IdNameOwnerDefinition idNameOwner, String tokenId, boolean bindings) {
            super(DescribeWebTokenOperation.NAME);
            this.idNameOwner = idNameOwner;
            this.tokenId = tokenId;
            this.bindings = bindings;
        }
    }
}

