/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.ListWebTokensOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DescribeWebApplicationOperation
extends AbstractWebOperation {
    public static final String NAME = "describe web application";

    public DescribeWebApplicationOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE WEB APPLICATION").addModifier(DescribeWebApplicationOperation.createApplicationIdNameOwnerModifier("Application", DescribeWebApplicationOperation::new));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("RESOURCES_OR_BINDINGS").addModifier(new Modifier("RESOURCES"))).addModifier(new Modifier("BINDINGS"))).addModifier(new Modifier("TOKENS"))).setRequired(false));
        this.syntax.setDescription("Describes WEB application.");
    }

    static CompoundModifier createApplicationIdNameOwnerModifier(String name, Supplier<AbstractWebOperation> syntaxSuplier) {
        return new CompoundModifier("WITH_COMPOUND").addModifier(new Modifier("WITH")).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("WITH_CHOICE").addModifier((AbstractModifier)new Modifier("ID").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "ID").setName("ID1")).setCompletionAdviser(new ApplicationIdCompletionAdvisor())))).addModifier(new CompoundModifier("NAME_OWNER_COMPOUND").addModifier((AbstractModifier)new Modifier("NAME").addParameter((SyntaxParameter)((StringParameter)new StringParameter(name + "Name").setName("Name")).setCompletionAdviser(new ApplicationNameCompletionAdvisor(null)))).addModifier((AbstractModifier)((Modifier)new Modifier("OWNED BY").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "Owner").setName("Owner")).setCompletionAdviser(new ApplicationOwnerCompletionAdvisor(syntaxSuplier)))).setRequired(false)))).addModifier(new CompoundModifier("OWNER_NAME_COMPOUND").addModifier((AbstractModifier)new Modifier("OWNER", "OWNER1").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter(name + "Owner").setName("Owner1")).setCompletionAdviser(new ApplicationOwnerCompletionAdvisor(null)))).addModifier((AbstractModifier)new Modifier("NAME", "NAME1").addParameter((SyntaxParameter)((StringParameter)new StringParameter(name + "Name").setName("Name1")).setCompletionAdviser(new ApplicationNameCompletionAdvisor(syntaxSuplier))))));
    }

    static Application getApplication(RuntimeContext callable, MFSession session, AbstractWebOperation.IdNameOwnerDefinition idNameOwner, boolean withResources) throws Exception {
        Application application = null;
        if (idNameOwner.id != null) {
            application = DescribeWebApplicationOperation.getHTTPAuthenticationManager(callable, session).getApiKeyServiceFactory().getApplicationService().get(idNameOwner.id, withResources);
            if (application == null) {
                throw new Exception("Application with specified ID not found.");
            }
        } else if (idNameOwner.name != null) {
            List<Application> applications;
            String owner = "*";
            if (idNameOwner.owner != null && idNameOwner.owner.length() > 0) {
                owner = idNameOwner.owner;
            }
            if ((applications = DescribeWebApplicationOperation.getHTTPAuthenticationManager(callable, session).getApiKeyServiceFactory().getApplicationService().getAll(owner, idNameOwner.name, true, true)) == null || applications.size() == 0) {
                if (idNameOwner.owner == null) {
                    throw new Exception("Application with specified name not found.");
                }
                throw new Exception("Application with specified name and owner not found.");
            }
            if (applications.size() > 1) {
                throw new Exception("More than one applications with specified name found. Please specify application owner or application ID.");
            }
            application = applications.get(0);
        }
        return application;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractWebOperation.IdNameOwnerDefinition.parse(statement), statement.getModifier("RESOURCES").isPresent(), statement.getModifier("BINDINGS").isPresent(), statement.getModifier("TOKENS").isPresent());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Application application = DescribeWebApplicationOperation.getApplication((RuntimeContext)this.callable, session, definition.idNameOwner, definition.resources);
        RowSet rowSet = null;
        if (definition.resources) {
            rowSet = new RowSet(DescribeWebApplicationOperation.createResultDescriptorResources());
            for (Application.Resource resource : application.getResources()) {
                rowSet.addToRowSet(new Object[]{resource.getMethod(), resource.getUrl(), resource.getName() != null ? resource.getName() : "", resource.getDescription() != null ? resource.getDescription() : ""});
            }
        } else if (definition.bindings) {
            rowSet = new RowSet(DescribeWebApplicationOperation.createResultDescriptorBindings());
            for (ApiKeySecurityBinding binding : application.getSecurityBindings()) {
                rowSet.addToRowSet(new Object[]{binding.toString()});
            }
        } else {
            if (definition.tokens) {
                return ListWebTokensOperation.getListTokens("*", application.getApplicationId(), session, this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyTokenService());
            }
            rowSet = new RowSet(DescribeWebApplicationOperation.createResultDescriptorProperties());
            rowSet.addToRowSet(new Object[]{"Name", application.getName()});
            rowSet.addToRowSet(new Object[]{"Description", application.getDescription()});
            rowSet.addToRowSet(new Object[]{"Application Id", application.getApplicationId()});
            rowSet.addToRowSet(new Object[]{"Owner", application.getOwner()});
            rowSet.addToRowSet(new Object[]{"Master Node", application.getMasterNode()});
            rowSet.addToRowSet(new Object[]{"Created At", DateParameter.formatDate(application.getCreatedAt())});
            rowSet.addToRowSet(new Object[]{"Global", application.isGlobal()});
        }
        return new SLResponse(rowSet);
    }

    static RowMetaData createResultDescriptorProperties() {
        RowMetaData result = new RowMetaData(10);
        DescribeWebApplicationOperation.addColumn(result, "Property");
        DescribeWebApplicationOperation.addColumn(result, "Value");
        return result;
    }

    static RowMetaData createResultDescriptorResources() {
        RowMetaData result = new RowMetaData(10);
        DescribeWebApplicationOperation.addColumn(result, "HTTP Method Mask");
        DescribeWebApplicationOperation.addColumn(result, "URL Mask");
        DescribeWebApplicationOperation.addColumn(result, "Name");
        DescribeWebApplicationOperation.addColumn(result, "Description");
        return result;
    }

    static RowMetaData createResultDescriptorBindings() {
        RowMetaData result = new RowMetaData(10);
        DescribeWebApplicationOperation.addColumn(result, "Security Binding");
        return result;
    }

    public static class ApplicationIdCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            return callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApplicationService().listApplications();
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class ApplicationNameCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        private Supplier<AbstractWebOperation> syntaxSupplier;
        private AbstractWebOperation operation;

        public ApplicationNameCompletionAdvisor(Supplier<AbstractWebOperation> syntaxSupplier) {
            this.syntaxSupplier = syntaxSupplier;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ApplicationService service = callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApplicationService();
            String user = null;
            if (this.syntaxSupplier != null) {
                if (this.operation == null) {
                    this.operation = this.syntaxSupplier.get();
                }
                try {
                    user = this.operation.parseDsl(processedScript + " ''").getParameter("Owner1").getValue(null);
                }
                catch (ParsingException exception) {
                    return new ArrayList<String>();
                }
            }
            if (user == null) {
                user = "*";
            }
            return new ArrayList<String>(service.getAll(user, null, false, true).stream().map(a -> "'" + a.getName() + "'").collect(Collectors.toSet()));
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class ApplicationOwnerCompletionAdvisor
    implements CompletionAdviser<RuntimeContext> {
        private Supplier<AbstractWebOperation> syntaxSupplier;
        private AbstractWebOperation operation;

        public ApplicationOwnerCompletionAdvisor(Supplier<AbstractWebOperation> syntaxSupplier) {
            this.syntaxSupplier = syntaxSupplier;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ApplicationService service = callable.getHTTPAuthenticationManager().authorize(session).getApiKeyServiceFactory().getApplicationService();
            String applicationName = null;
            if (this.syntaxSupplier != null) {
                if (this.operation == null) {
                    this.operation = this.syntaxSupplier.get();
                }
                try {
                    applicationName = this.operation.parseDsl(processedScript + " user").getParameter("Name").getValue(null);
                }
                catch (ParsingException exception) {
                    return new ArrayList<String>();
                }
            }
            return service.getAll("*", applicationName, false, true).stream().map(a -> a.getOwner()).collect(Collectors.toList());
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private AbstractWebOperation.IdNameOwnerDefinition idNameOwner;
        private boolean resources;
        private boolean bindings;
        private boolean tokens;

        public Definition(AbstractWebOperation.IdNameOwnerDefinition idNameOwner, boolean resources, boolean bindings, boolean tokens) {
            super(DescribeWebApplicationOperation.NAME);
            this.idNameOwner = idNameOwner;
            this.resources = resources;
            this.bindings = bindings;
            this.tokens = tokens;
        }
    }
}

