/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.CreateWebApplicationOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebApplicationOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class CreateWebTokenOperation
extends AbstractWebOperation {
    public static final String NAME = "create web token";

    public CreateWebTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE WEB TOKEN");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NAME").addParameter(new StringParameter("Name"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("APPLICATION").addParameter((SyntaxParameter)new IdentifierParameter("ApplicationId").setCompletionAdviser(new DescribeWebApplicationOperation.ApplicationIdCompletionAdvisor())));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EXPIRES IN").addParameter(new IntegerParameter("ExpiresIn"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EXTEND PERIOD").addParameter(new IntegerParameter("ExtendPeriod"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DELETE TIMEOUT").addParameter(new IntegerParameter("DeleteTimeout"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("GLOBAL").setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("SECURITY BINDINGS").addModifier(CreateWebApplicationOperation.createBindingsRepeatableModifier()).setRequired(false));
        this.syntax.setDescription("Creates new web token.\n\nParameters:\n  name              - name of the token.\n  description       - description of the token.\n  application       - ID of web application that can be accessed with this token.\n  expires in        - defines timeout in seconds to wait since token was created or last accessed(depends on extend period parameter),\n                      before token being expired. Value -1 means never expired.\n  extend period     - defines time in seconds between updates of token last accessed time in dataspace. Value -1 means no extend.\n  delete timeout    - defines timeout in seconds to wait since token expiration, before token deletion. Value -1 means don't wait.\n  global            - specifies if web token should be replicated in sysplex.\n  security bindings - specifies how HTTP request should be bound to its web token. If empty then no binding will be done. The following values are allowed:\n                        user_agent_on_authentication  - bind token to User-Agent of HTTP request on authentication.\n                        user_agent_on_first_token_use - bind token to User-Agent of HTTP request on first use.\n                        session_on_authentication     - bind token to HTTP session of HTTP request on authentication.\n                        session_on_first_token_use    - bind token to HTTP session of HTTP request on first use.\n\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        ApiKeyToken apiKeyToken = new ApiKeyToken();
        apiKeyToken.setName(statement.getParameter("Name").getValue());
        apiKeyToken.setDescription(statement.getParameter("Description").getValue());
        apiKeyToken.setApplicationId(statement.getParameter("ApplicationId").getValue());
        apiKeyToken.setExpiresIn(statement.getParameter("ExpiresIn").getValue(-1));
        apiKeyToken.setExtendPeriod(statement.getParameter("ExtendPeriod").getValue(-1));
        apiKeyToken.setDeleteTimeoutAfterExpiration(statement.getParameter("DeleteTimeout").getValue(-1));
        apiKeyToken.setGlobal(statement.getModifier("GLOBAL").isPresent());
        apiKeyToken.setSecurityBindings(CreateWebApplicationOperation.getSecurityBindings(statement));
        this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyTokenService().create(apiKeyToken);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(CreateWebTokenOperation.NAME);
            this.statement = statement;
        }
    }
}

