/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CreateWebApplicationOperation
extends AbstractWebOperation {
    public static final String NAME = "create web application";
    public static final String RESOURCES_HELP = "HTTP methods can be specified by adding them together, for example\n  - *        - any HTTP method\n  - POST     - only POST HTTP method\n  - GET|POST - only POST or GET HTTP methods\n\nURL mask has format like JAX-RS path templates. Common URL mask format: /segment1/segment2/....[/*].\nAllowed values for segments:\n  - mysegment                     - means segment with value 'mysegment'\n  - {somename}                    - means any segment\n  - {somename:regular expression} - means any segment that matches specified regular expression\n  - asterisk at the end           - means any segments at the end\n\nURL mask examples:\n  - /department/employees               - one URL /department/employees\n  - /department/employees/*             - any URL that starts with /department/employees/\n  - /department/{myanysegment}/projects - any URL that starts with /department, any second segment and third segment is projects\n  - /department/{c:\\d*}/projects       - any URL that starts with /department, second segment contains only digits and third segment is projects";

    public CreateWebApplicationOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE WEB APPLICATION");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NAME").addParameter(new StringParameter("Name"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("GLOBAL").setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("RESOURCES").addModifier(CreateWebApplicationOperation.createResourceRepeatableModifier()).setRequired(false));
        this.syntax.addModifier(CreateWebApplicationOperation.createSecurityBindingsBlockModifier(false));
        this.syntax.setDescription("Creates new web application.\n\nWeb application defines set of resources that can be accessed by user authenticated in this application.\nTo access web application resources user should provide web token issued for this application.\n\nParameters:\n  name              - name of web application.\n  description       - description of web application.\n  global            - specifies if application should be replicated in sysplex.\n  resources         - list of pairs of HTTP method and URL masks that defines matching rules to define if HTTP request belongs to this application or not.\n  security bindings - specifies how HTTP request should be bound to its web token. If empty then no binding will be done. The following values are allowed:\n                        user_agent_on_authentication  - bind token to User-Agent of HTTP request on authentication.\n                        user_agent_on_first_token_use - bind token to User-Agent of HTTP request on first use.\n                        session_on_authentication     - bind token to HTTP session of HTTP request on authentication.\n                        session_on_first_token_use    - bind token to HTTP session of HTTP request on first use.\n\nTo get access to some web application HTTP request should provide valid web token(issued for this application) and\nits HTTP method and URL should satisfy to one of resources of this web application.\n\nHTTP methods can be specified by adding them together, for example\n  - *        - any HTTP method\n  - POST     - only POST HTTP method\n  - GET|POST - only POST or GET HTTP methods\n\nURL mask has format like JAX-RS path templates. Common URL mask format: /segment1/segment2/....[/*].\nAllowed values for segments:\n  - mysegment                     - means segment with value 'mysegment'\n  - {somename}                    - means any segment\n  - {somename:regular expression} - means any segment that matches specified regular expression\n  - asterisk at the end           - means any segments at the end\n\nURL mask examples:\n  - /department/employees               - one URL /department/employees\n  - /department/employees/*             - any URL that starts with /department/employees/\n  - /department/{myanysegment}/projects - any URL that starts with /department, any second segment and third segment is projects\n  - /department/{c:\\d*}/projects       - any URL that starts with /department, second segment contains only digits and third segment is projects\n\nSamples:\n  create web application\n    name 'EmployeesReadApplication'\n    description 'Global web application that allows read of employee related resources.'\n    global\n    resources(method 'GET' url '/employees/*', method 'GET' url '/organizations/*')\n    security bindings(user_agent_on_first_token_use, session_on_first_token_use)\n");
    }

    public static BlockModifier createSecurityBindingsBlockModifier(boolean set) {
        return (BlockModifier)((BlockModifier)new BlockModifier((set ? "SET " : "") + "SECURITY BINDINGS").setName("SECURITY BINDINGS")).addModifier(CreateWebApplicationOperation.createBindingsRepeatableModifier()).setRequired(false);
    }

    static RepeatableModifier createResourceRepeatableModifier() {
        return (RepeatableModifier)new RepeatableModifier().addModifier(new CompoundModifier("RESOURCES_COMPOUND_MODIFIER").addModifier((AbstractModifier)new Modifier("METHOD").addParameter((SyntaxParameter)new StringParameter("http method mask").setName("method"))).addModifier((AbstractModifier)new Modifier("URL").addParameter((SyntaxParameter)new StringParameter("url mask").setName("url"))).addModifier((AbstractModifier)((Modifier)new Modifier("NAME").addParameter((SyntaxParameter)new StringParameter("resource name").setName("name"))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter((SyntaxParameter)new StringParameter("resource description").setName("description"))).setRequired(false)));
    }

    static RepeatableModifier createBindingsRepeatableModifier() {
        return (RepeatableModifier)new RepeatableModifier().addParameter(new EnumParameter("BINDING", ApiKeySecurityBinding.class).addPossibleValue("none"));
    }

    static List<Application.Resource> getResources(DSLStatement statement, String name) {
        ArrayList<Application.Resource> resources = null;
        StatementBlockValue block = statement.getBlock(name);
        if (block.isPresent()) {
            for (int i = 0; i < block.getLinesCount(); ++i) {
                StatementValueList line = block.getLineByIndex(i);
                Application.Resource resource = new Application.Resource();
                resource.setMethod(line.getParameter("method").getValue());
                resource.setUrl(line.getParameter("url").getValue());
                resource.setName(line.getParameter("name").getValue());
                resource.setDescription(line.getParameter("description").getValue());
                if (resources == null) {
                    resources = new ArrayList<Application.Resource>();
                }
                resources.add(resource);
            }
        }
        return resources;
    }

    public static boolean isSecurityBindingsPresent(DSLStatement statement) {
        return statement.getBlock("SECURITY BINDINGS").isPresent();
    }

    public static Set<ApiKeySecurityBinding> getSecurityBindings(DSLStatement statement) {
        HashSet<ApiKeySecurityBinding> bindings = new HashSet<ApiKeySecurityBinding>();
        StatementBlockValue block = statement.getBlock("SECURITY BINDINGS");
        if (block.isPresent()) {
            for (int i = 0; i < block.getLinesCount(); ++i) {
                StatementValueList line = block.getLineByIndex(i);
                String value = ((StatementParameterValue)line.getValue(0)).getValue().toUpperCase();
                if (value.equalsIgnoreCase("none")) {
                    bindings.clear();
                    break;
                }
                bindings.add(ApiKeySecurityBinding.valueOf(value));
            }
        }
        return bindings;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        Application application = new Application();
        application.setName(statement.getParameter("Name").getValue());
        application.setDescription(statement.getParameter("Description").getValue());
        application.setGlobal(statement.getModifier("GLOBAL").isPresent());
        application.setResources(CreateWebApplicationOperation.getResources(statement, "RESOURCES"));
        application.setSecurityBindings(CreateWebApplicationOperation.getSecurityBindings(statement));
        ApplicationService service = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApplicationService();
        service.create(application);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(CreateWebApplicationOperation.NAME);
            this.statement = statement;
        }
    }
}

