/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebTokenOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class AlterWebTokenOperation
extends AbstractWebOperation {
    public static final String NAME = "alter web token";

    public AlterWebTokenOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER WEB TOKEN").addModifier(DescribeWebTokenOperation.createTokenIdNameOwnerModifier("Token", AlterWebTokenOperation::new));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EXPIRES IN").addParameter(new IntegerParameter("ExpiresIn"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EXTEND PERIOD").addParameter(new IntegerParameter("ExtendPeriod"))).setRequired(false));
        this.syntax.setDescription("Alters web token.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        ApiKeyToken apiKeyToken = DescribeWebTokenOperation.getApiKeyToken((RuntimeContext)this.callable, session, AbstractWebOperation.IdNameOwnerDefinition.parse(statement));
        if (apiKeyToken == null) {
            throw new Exception("Token not found.");
        }
        if (statement.getParameter("Description").isPresent()) {
            apiKeyToken.setDescription(statement.getParameter("Description").getValue());
        }
        if (statement.getParameter("ExpiresIn").isPresent()) {
            apiKeyToken.setExpiresIn(Integer.valueOf(statement.getParameter("ExpiresIn").getValue()));
        }
        if (statement.getParameter("ExtendPeriod").isPresent()) {
            apiKeyToken.setExtendPeriod(Integer.valueOf(statement.getParameter("ExtendPeriod").getValue()));
        }
        ApiKeyTokenService service = this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyTokenService();
        service.update(apiKeyToken);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AlterWebTokenOperation.NAME);
            this.statement = statement;
        }
    }
}

