/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class AlterWebPropertyOperation
extends AbstractWebOperation {
    public static final String NAME = "alter web property";

    public AlterWebPropertyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER WEB PROPERTY");
        this.syntax.addModifier(this.createPropertyBlockModifier());
        this.syntax.setDescription("Sets web property values.");
    }

    private BlockModifier createPropertyBlockModifier() {
        ExpressionParameter nameParameter = new ExpressionParameter("name");
        nameParameter.setCompletionAdviser(new PropertyNameAdviser());
        return (BlockModifier)new BlockModifier("SET", "propertyBlockModifier").addModifier(new CompoundModifier("propertyCompoundModifier").addParameter(nameParameter).addModifier(new Modifier("=", "equals")).addParameter(new IntegerParameter("value"))).setSyntaxHint(SyntaxHint.SPACE);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementValueList line = statement.getBlock("propertyBlockModifier").getLineByIndex(0);
        return new Definition(line.getParameter("name").getValue(), line.getParameter("value").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyDefaultsService().setPropertyValue(definition.propertyName, definition.propertyValue);
        return new SLResponse();
    }

    private class PropertyNameAdviser
    implements CompletionAdviser<ServiceContext> {
        private PropertyNameAdviser() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, ServiceContext callable, MFSession session) {
            return new ArrayList<String>(AlterWebPropertyOperation.this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApiKeyDefaultsService().listProperties());
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        String propertyName;
        String propertyValue;

        Definition(String propertyName, String propertyValue) {
            super(AlterWebPropertyOperation.NAME);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

