/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.http;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.http.AbstractWebOperation;
import com.streamscape.runtime.mf.operation.http.CreateWebApplicationOperation;
import com.streamscape.runtime.mf.operation.http.DescribeWebApplicationOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.List;

public class AlterWebApplicationOperation
extends AbstractWebOperation {
    public static final String NAME = "alter web application";

    public AlterWebApplicationOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER WEB APPLICATION").addModifier(DescribeWebApplicationOperation.createApplicationIdNameOwnerModifier("Application", AlterWebApplicationOperation::new));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("SET RESOURCES").addModifier(CreateWebApplicationOperation.createResourceRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("REMOVE RESOURCES").addModifier(CreateWebApplicationOperation.createResourceRepeatableModifier()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new BlockModifier("ADD RESOURCES").addModifier(CreateWebApplicationOperation.createResourceRepeatableModifier()).setRequired(false));
        this.syntax.addModifier(CreateWebApplicationOperation.createSecurityBindingsBlockModifier(true));
        this.syntax.setDescription("Alters web application.\n\nSee parameters description on create web application operation.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getBlock("SET RESOURCES").isPresent() && (statement.getBlock("REMOVE RESOURCES").isPresent() || statement.getBlock("ADD RESOURCES").isPresent())) {
            throw new ParsingException("Set resources cannot be specified with remove/add resources.");
        }
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        List<Application.Resource> resources;
        DSLStatement statement = ((Definition)definition).statement;
        Application application = DescribeWebApplicationOperation.getApplication((RuntimeContext)this.callable, session, AbstractWebOperation.IdNameOwnerDefinition.parse(statement), true);
        if (application == null) {
            throw new Exception("Application doesn't exist.");
        }
        if (statement.getParameter("Description").isPresent()) {
            application.setDescription(statement.getParameter("Description").getValue());
        }
        if ((resources = CreateWebApplicationOperation.getResources(statement, "SET RESOURCES")) != null) {
            application.setResources(resources);
        }
        if ((resources = CreateWebApplicationOperation.getResources(statement, "REMOVE RESOURCES")) != null) {
            application.removeResources(resources);
        }
        if ((resources = CreateWebApplicationOperation.getResources(statement, "ADD RESOURCES")) != null) {
            application.addResources(resources);
        }
        if (CreateWebApplicationOperation.isSecurityBindingsPresent(statement)) {
            application.setSecurityBindings(CreateWebApplicationOperation.getSecurityBindings(statement));
        }
        this.getHTTPAuthenticationManager(session).getApiKeyServiceFactory().getApplicationService().update(application);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AlterWebApplicationOperation.NAME);
            this.statement = statement;
        }
    }
}

