/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.group;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.group.AbstractGroupOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Collections;
import java.util.List;

public class ListFabricGroupsOperation
extends AbstractGroupOperation {
    private static final String NAME = "list fabric groups";

    public ListFabricGroupsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST FABRIC GROUPS");
        this.syntax.setDescription("Returns a list of all fabric groups in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListFabricGroupsOperation.createResultDescriptor());
        List<FabricGroup> groups = ((RuntimeContext)this.callable).getGroupManager().getGroups();
        Collections.sort(groups);
        for (FabricGroup group : groups) {
            result.addToRowSet(new Object[]{group.getName(), group.getDescription(), group.getMembers().size()});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListFabricGroupsOperation.addColumn(result, "Name");
        ListFabricGroupsOperation.addColumn(result, "Description");
        ListFabricGroupsOperation.addColumn(result, "Members");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListFabricGroupsOperation.NAME);
        }
    }
}

