/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.group;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.group.AbstractGroupOperation;
import com.streamscape.runtime.mf.operation.moderator.ListComponentsOperation;
import com.streamscape.runtime.mf.operation.moderator.ListConsumersOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DescribeFabricGroupOperation
extends AbstractGroupOperation {
    private static final String NAME = "describe fabric group";

    public DescribeFabricGroupOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE FABRIC GROUP");
        this.syntax.setPredicate((ChoiceModifier)new ChoiceModifier().addPossibleValue("COMPONENTS").addPossibleValue("CONSUMERS").setRequired(false));
        this.syntax.setSubject((Subject)new Subject("").addParameter(new IdentifierParameter("GroupName")));
        this.syntax.setDescription("Shows information about the specified fabric group.");
        this.syntax.setExamples("describe fabric group ExampleGroup");
        this.syntax.addCompletionCommand("list fabric groups");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("GroupName").getValue(), statement.existsValue("COMPONENTS"), statement.existsValue("CONSUMERS"));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getGroupManager().listGroups());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        FabricGroup group = ((RuntimeContext)this.callable).getGroupManager().lookupGroup(((Definition)statement).groupName);
        return group != null ? new SLResponse(this.createResult(session, group, (Definition)statement)) : new SLResponse("Group not found.", false);
    }

    RowSet createResult(MFSession session, FabricGroup group, Definition definition) throws Exception {
        RowSet result;
        if (definition.needComponents) {
            result = new RowSet(this.createResultDescriptorForComponents());
            this.addComponent(session, group.getMembers(), result);
        } else if (definition.needConsumers) {
            result = new RowSet(DescribeFabricGroupOperation.createResultDescriptorForConsumers());
            this.addConsumers(((RuntimeContext)this.callable).getModerator().getEventConsumers(group.getName()), session, result);
        } else {
            result = new RowSet(DescribeFabricGroupOperation.createResultDescriptor());
            result.addToRowSet(new Object[]{"Name", group.getName()});
            result.addToRowSet(new Object[]{"Description", DescribeFabricGroupOperation.skipNull(group.getDescription())});
            result.addToRowSet(new Object[]{"Members", group.listMembers()});
        }
        return result;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeFabricGroupOperation.addColumn(result, "Property");
        DescribeFabricGroupOperation.addColumn(result, "Value");
        return result;
    }

    protected RowMetaData createResultDescriptorForComponents() {
        return ListComponentsOperation.createResultDescriptor();
    }

    protected void addComponent(MFSession session, List<ComponentReference> components, RowSet result) throws Exception {
        ListComponentsOperation.addComponents(session, components, false, null, result);
    }

    protected static RowMetaData createResultDescriptorForConsumers() {
        return ListConsumersOperation.createResultDescriptor();
    }

    protected void addConsumers(List<EventConsumerReference> consumers, MFSession session, RowSet result) throws Exception {
        ListConsumersOperation.addConsumers(consumers, null, session, ((RuntimeContext)this.callable).getModerator(), result);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String groupName;
        private boolean needComponents;
        private boolean needConsumers;

        public Definition(String groupName) {
            super(DescribeFabricGroupOperation.NAME);
            this.groupName = groupName;
        }

        public Definition(String groupName, boolean needComponents, boolean needConsumers) {
            this(groupName);
            this.needComponents = needComponents;
            this.needConsumers = needConsumers;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean needComponents() {
            return this.needComponents;
        }

        public boolean needConsumers() {
            return this.needConsumers;
        }
    }
}

