/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Base64;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.runtime.mf.operation.glv.AddGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.List;

public class SetGlobalVariableOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "set global variable";

    public SetGlobalVariableOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET GLOBAL VARIABLE").addActionParameter(new AddGlobalVariableOperation.GlvPoolVariableNameParameter());
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("ValueModifier").setSyntaxHint(SyntaxHint.SPACE)).addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Value")))).addModifier(new BlockModifier("$password:").addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Password")))));
        this.syntax.setDescription("Sets the specified value to the specified global variable.\nIf the variable does not exist it will be added.");
        this.syntax.setExamples("set global variable Pool1.Variable1 'Value1'\nset global variable Pool1.Password $password:('123')");
        this.syntax.addCompletionCommand("list global variables");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return statement.existsParameter("Value") ? new Definition(statement.getParameter("PoolName").getValue(), statement.getParameter("VariableName").getValue(), statement.getParameter("Value").getValue(), false) : new Definition(statement.getParameter("PoolName").getValue(), statement.getParameter("VariableName").getValue(), statement.getBlock("$password:").getLineByIndex(0).getParameter("Password").getValue(), true);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            GlobalVariableCollection globalVariables = VariableFactory.getGlobalVariables();
            for (String variableName : globalVariables.listLiteralPoolVariables("SYS")) {
                completions.add(variableName);
            }
            for (String poolName : globalVariables.listLiteralPools()) {
                if (poolName.equals("SYS")) continue;
                for (String variableName : globalVariables.listLiteralPoolVariables(poolName)) {
                    completions.add(poolName + "." + variableName);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        VariableFactory.setVariable(definition.poolName != null ? definition.poolName : "SYS", definition.variableName, definition.isPassword ? this.convertPassword(definition.variableValue) : definition.variableValue);
        return new SLResponse();
    }

    private String convertPassword(String password) {
        return "$password:(" + Base64.encodeBytes(password.getBytes()) + ")";
    }

    public static class Definition
    extends AbstractSLStatement {
        private String poolName;
        private String variableName;
        private String variableValue;
        private boolean isPassword;

        public Definition(String poolName, String variableName, String variableValue, boolean isPassword) {
            super(SetGlobalVariableOperation.NAME);
            this.poolName = poolName;
            this.variableName = variableName;
            this.variableValue = variableValue;
            this.isPassword = isPassword;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getVariableValue() {
            return this.variableValue;
        }

        public boolean isPassword() {
            return this.isPassword;
        }
    }
}

