/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.Trace;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.runtime.mf.operation.glv.AddGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class RemoveGlobalVariableOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "remove global variable";

    public RemoveGlobalVariableOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE GLOBAL VARIABLE").addModifier(new AddGlobalVariableOperation.GlvPoolOrPoolVariableNameParameter());
        this.syntax.setDescription("Removes the specified global variable or global variable pool.");
        this.syntax.setExamples("remove global variable MyPool.Variable1\nremove global variable pool MyPool");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("POOL"), statement.getParameter("PoolName").getValue(), statement.getParameter("VariableName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            GlobalVariableCollection globalVariables = VariableFactory.getGlobalVariables();
            for (String variableName : globalVariables.listLiteralPoolVariables("SYS")) {
                completions.add(variableName);
            }
            for (String poolName : globalVariables.listLiteralPools()) {
                if (poolName.equals("SYS")) continue;
                for (String variableName : globalVariables.listLiteralPoolVariables(poolName)) {
                    completions.add(poolName + "." + variableName);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.isPool) {
            VariableFactory.removeLiteralPool(definition.getPoolName());
        } else {
            VariableFactory.removeVariable(definition.poolName != null ? definition.poolName : "SYS", definition.variableName);
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean isPool;
        private String poolName;
        private String variableName;

        public Definition(boolean isPool, String poolName, String variableName) {
            super(RemoveGlobalVariableOperation.NAME);
            this.isPool = isPool;
            this.poolName = poolName;
            this.variableName = variableName;
        }

        public boolean isPool() {
            return this.isPool;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }
}

