/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class ListGlobalVariablesOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "list global variables";

    public ListGlobalVariablesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST GLOBAL VARIABLES").addActionParameter((SyntaxParameter)new IdentifierParameter("PoolName").setRequired(false));
        this.syntax.setDescription("Returns a list of global variables containing in a pool with the specified name.\nIf the pool name is not specified, a list of global variables from all pools is returned.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("PoolName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        GlobalVariableCollection globalVariables = VariableFactory.getGlobalVariables();
        RowSet result = new RowSet(ListGlobalVariablesOperation.createResultDescriptor(definition.getPoolName() != null));
        if (definition.getPoolName() == null) {
            for (String poolName : globalVariables.listLiteralPools()) {
                for (String variableName : globalVariables.listLiteralPoolVariables(poolName)) {
                    result.addToRowSet(new Object[]{poolName, variableName, this.convertValue(globalVariables.getVariable(poolName, variableName))});
                }
            }
        } else {
            for (String variableName : globalVariables.listLiteralPoolVariables(definition.getPoolName())) {
                result.addToRowSet(new Object[]{variableName, this.convertValue(globalVariables.getVariable(definition.getPoolName(), variableName))});
            }
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(boolean isPool) {
        RowMetaData result = new RowMetaData();
        if (!isPool) {
            ListGlobalVariablesOperation.addColumn(result, "Pool");
        }
        ListGlobalVariablesOperation.addColumn(result, "Name");
        ListGlobalVariablesOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String poolName;

        public Definition(String poolName) {
            super(ListGlobalVariablesOperation.NAME);
            this.poolName = poolName;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }
}

