/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListGlobalVariablePoolsOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "list global variable pools";

    public ListGlobalVariablePoolsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST GLOBAL VARIABLE POOLS");
        this.syntax.setDescription("Returns a list of pools containing global variables.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListGlobalVariablePoolsOperation.createResultDescriptor());
        GlobalVariableCollection globalVariables = VariableFactory.getGlobalVariables();
        for (String poolName : globalVariables.listLiteralPools()) {
            result.addToRowSet(new Object[]{poolName});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListGlobalVariablePoolsOperation.addColumn(result, "Pool");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListGlobalVariablePoolsOperation.NAME);
        }
    }
}

