/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.Trace;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.runtime.mf.operation.glv.AddGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class GetGlobalVariableOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "get global variable";

    public GetGlobalVariableOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("GET GLOBAL VARIABLE").addActionParameter(new AddGlobalVariableOperation.GlvPoolVariableNameParameter());
        this.syntax.setDescription("Shows a value of the specified global variable.");
        this.syntax.addCompletionCommand("list global variables");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("PoolName").getValue(), statement.getParameter("VariableName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            GlobalVariableCollection globalVariables = VariableFactory.getGlobalVariables();
            for (String variableName : globalVariables.listLiteralPoolVariables("SYS")) {
                completions.add(variableName);
            }
            for (String poolName : globalVariables.listLiteralPools()) {
                if (poolName.equals("SYS")) continue;
                for (String variableName : globalVariables.listLiteralPoolVariables(poolName)) {
                    completions.add(poolName + "." + variableName);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        return new SLResponse(this.convertValue(VariableFactory.getVariable(definition.poolName != null ? definition.poolName : "SYS", definition.variableName)));
    }

    public static class Definition
    extends AbstractSLStatement {
        private String poolName;
        private String variableName;

        public Definition(String poolName, String variableName) {
            super(GetGlobalVariableOperation.NAME);
            this.poolName = poolName;
            this.variableName = variableName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }
}

