/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.glv;

import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.glv.AbstractGlobalVariableOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class AddGlobalVariableOperation
extends AbstractGlobalVariableOperation {
    public static final String NAME = "add global variable";

    public AddGlobalVariableOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD GLOBAL VARIABLE").addModifier(new GlvPoolOrPoolVariableNameParameter());
        this.syntax.setDescription("Adds a global variable with the specified name and empty value.\nor\nAdds a global variable pool with the specified name.");
        this.syntax.setExamples("add global variable MyPool.Variable1\nadd global variable pool MyPool");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("POOL"), statement.getParameter("PoolName").getValue(), statement.getParameter("VariableName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.isPool) {
            VariableFactory.addLiteralPool(definition.poolName);
        } else {
            VariableFactory.addVariable(definition.poolName != null ? definition.poolName : "SYS", definition.variableName);
        }
        return new SLResponse();
    }

    public static class GlvPoolOrPoolVariableNameParameter
    extends ChoiceModifier {
        GlvPoolOrPoolVariableNameParameter() {
            this.addParameter(new GlvPoolVariableNameParameter());
            this.addModifier((AbstractModifier)new Modifier("POOL").addParameter(new IdentifierParameter("PoolName")));
            this.setSyntaxHint(SyntaxHint.SPACE);
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean isPool;
        private String poolName;
        private String variableName;

        public Definition(boolean isPool, String poolName, String variableName) {
            super(AddGlobalVariableOperation.NAME);
            this.isPool = isPool;
            this.poolName = poolName;
            this.variableName = variableName;
        }

        public boolean isPool() {
            return this.isPool;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }

    public static class GlvPoolVariableNameParameter
    extends CompoundParameter {
        GlvPoolVariableNameParameter() {
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter("PoolName").setRequired(false));
            this.addParameter(new IdentifierParameter("VariableName"));
        }
    }
}

