/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.io.File;

public class ShowRestoreLogOperation
extends AbstractFrmNodeOperation<RuntimeContext> {
    public static final String NAME = "show restore log";

    public ShowRestoreLogOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW RESTORE LOG");
        this.syntax.setDescription("Shows a log of the latest 'restore node' operation.");
        this.syntax.setInitialVersion("3.8 Build 22");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        File logFile = ((RuntimeContext)this.callable).getFileInStartupDir("Restore.log");
        if (!logFile.exists()) {
            throw new Exception("Log file not found.");
        }
        return new SLResponse(new String(FileIOUtils.getFileContent(logFile)));
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowRestoreLogOperation.addColumn(result, "Log");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(ShowRestoreLogOperation.NAME);
        }
    }
}

