/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFile;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class RestoreNodeOperation<T extends RuntimeContext>
extends AbstractFrmNodeOperation<T> {
    public static final String NAME = "restore";
    public static final String ALIAS = "restore node";
    private FileWriter logWriter;
    private boolean relaunchInProgress;
    public static final String LOG_FILENAME = "Restore.log";
    private static final String SECURITY_PATH = FrmEntityType.OBJECT.getRelativePath() + "/sys/security";

    public RestoreNodeOperation() {
        this(NAME);
    }

    protected RestoreNodeOperation(String name) {
        super(true);
        this.createDSLSyntax(name);
        this.syntax.setAction(name);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM").addParameter((SyntaxParameter)new SLFilePathParameter("FrmPath").setCompactSyntax("<FRM File Path>"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("PASSWORD", false).addParameter(new StringParameter("Password")));
        this.syntax.setSyntaxDescription("Parameters:\n\n   from      - Full path to the FRM file.\n\nOptional parameters:\n\n   password  - Password that is used to decrypt the FRM file, if encrypted.\n               This requires knowledge of password used in BACKUP or extract operation.\n" + this.getOtherSyntaxDescription());
        this.doInit();
    }

    protected void doInit() {
        this.syntax.setAlias(ALIAS);
        this.syntax.addModifier(new ChoiceModifier(false).addPossibleValues("FORCE", "PRESERVE"));
        this.syntax.setDescription("Restores a current node using the content of a specified Fabric Resource Module (FRM).\nIt is expected that the FRM was created using a corresponding BACKUP command and contains\na full node image.\n\nThis operation erases all files in the node (and its storage cache) and loads all\ncontents from the specified FRM, performing a full, destructive load operation.\nBy default, the original deployment descriptor is retained and not replaced by the one from FRM.\nTherefore, the Node Name, Domain and Runtime Security Credentials of the target node are retained.\nThese parameters must match as it is assumed that the node is being restored from its own backup.\nThis default behavior can be changed with FORCE or PRESERVE options.\n\nInformation about the operation steps and results is written to Restore.log file.");
        this.syntax.setExamples("restore node from 'C:/Streamscape/resources/Node1.frm'\nrestore node from 'C:/Streamscape/resources/Node1.frm' password '123'\nrestore node from 'C:/Streamscape/resources/Node1.frm' force\nrestore node from 'C:/Streamscape/resources/Node1.frm' password '123' preserve");
        this.syntax.setInitialVersion("3.8 Build 22");
    }

    protected String getOtherSyntaxDescription() {
        return "\n   force     - Allows Admin to restore all content including the original Deployment Descriptor\n               and Security DB without any validation. After restore the node may thus have\n               different Node Name, Domain and Security Credentials then original.\n               This may be necessary if Node's security and ownership relies on specific users\n               to be present. This is an advanced function that may result in a Node's security\n               scope being incompatible with an existing Domain.\n\n   preserve  - Retains the target Deployment Descriptor and Security DB but restores all other\n               content from the FRM. Therefore, the Node Name, Domain and Runtime Security Credentials\n               of the target node are retained without any validation.\n               Note that this may cause security issues if the resource owners(dataspace,\n               collection or service) are not in the Security DB of the target node.\n\n";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = this.createDefinition(statement.existsParameter("NodeName") ? statement.getParameter("NodeName").getValue() : null, statement.getParameter("FrmPath").getValue(), !statement.existsModifier("WithWait"), statement.getParameter("Password").getValue());
        if (statement.existsModifier("FORCE")) {
            definition.type = OperationType.FORCE;
        } else if (statement.existsModifier("PRESERVE")) {
            definition.type = OperationType.PRESERVE;
        }
        return definition;
    }

    protected Definition createDefinition(String nodeName, String frmPath, boolean isAsync, String password) {
        return new Definition(this.getName(), nodeName, frmPath, isAsync, password);
    }

    @Override
    protected void checkBeforeExecute(AbstractFrmNodeOperation.Definition definition, MFSession session) throws Exception {
        String mnodeName = this.getMnodeName(((RuntimeContext)this.callable).getModerator().getFabricNode());
        if (mnodeName != null) {
            throw new FabricException("This Task Node is managed by Management Node [" + mnodeName + "]. Use 'restore managed node' command.");
        }
    }

    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.relaunchInProgress = false;
        File workingDir = this.getWorkingDir(definition);
        File ddxFile = this.getDdxFile(definition);
        File frmDir = this.getFrmDir(workingDir, definition);
        File frmFile = new File(workingDir, frmDir.getName() + ".frm");
        File frmDdxFile = new File(new File(frmDir, workingDir.toPath().relativize(ddxFile.getParentFile().toPath()).toString()), "stdeploy.jar");
        try {
            File logFile = this.initLog(workingDir);
            this.raiseSLMessage("\nRestoring node [" + this.getNodeName(definition) + "] started on " + DATE_TIME_FORMAT.format(new Date()) + ".\n", session);
            this.uploadFrmFile(frmFile, definition, session);
            this.extractFrmFile(frmDir, frmFile, definition, session);
            this.validateFrmFile(workingDir, frmDir, ddxFile, frmDdxFile, definition, session);
            this.unloadNode(definition, session);
            this.cleanWorkingDir(workingDir, frmDir, ddxFile, frmDdxFile, logFile, definition, session);
            this.restoreWorkingDir(workingDir, frmDir, session);
            this.loadNode(definition, session);
            this.raiseSLMessage("\n\nRestoring node [" + this.getNodeName(definition) + "] completed on " + DATE_TIME_FORMAT.format(new Date()) + ".\n\n", session);
        }
        catch (Exception exception) {
            this.writeInLog("\nERROR: " + Utils.formatException(exception, "\n       ") + "\n");
            if (!RuntimeContext.isInitialized()) {
                this.onExit(frmDir, frmFile);
                System.exit(-1);
            }
            throw exception;
        }
        finally {
            this.onExit(frmDir, frmFile);
        }
        return new SLResponse();
    }

    protected File getWorkingDir(Definition definition) throws Exception {
        return new File(((RuntimeContext)this.callable).getStartupDir()).getCanonicalFile();
    }

    protected File getDdxFile(Definition definition) throws Exception {
        return new File(((RuntimeContext)this.callable).getDeploymentDescriptorFilename()).getCanonicalFile();
    }

    protected File getFrmDir(File workingDir, Definition definition) throws Exception {
        return new File(workingDir, this.getNodeName(definition) + System.currentTimeMillis());
    }

    protected String getNodeName(Definition definition) {
        return ((RuntimeContext)this.callable).getName();
    }

    protected String getDomain(Definition definition) {
        return ((RuntimeContext)this.callable).getDomain();
    }

    protected File initLog(File workingDir) throws Exception {
        File logFile = new File(workingDir, LOG_FILENAME);
        this.logWriter = new FileWriter(logFile);
        return logFile;
    }

    private void uploadFrmFile(File frmFile, Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\nUploading FRM...\n\n", session);
        this.sleepProgressMonitor();
        try (FileOutputStream outputStream = new FileOutputStream(frmFile);){
            ((SLFileUtils)new SLFileUtilsFactory().create(session, definition.getFrmPath())).readFile(outputStream);
        }
        catch (FileNotFoundException exception) {
            throw new IOException("FRM file not found.");
        }
        this.raiseSLMessage("\nFRM uploaded.", session);
    }

    private void extractFrmFile(File frmDir, File frmFile, Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nExtracting FRM to temporary directory...", session);
        this.wakeUpProgressMonitor();
        frmDir.mkdirs();
        FrmFile.extract(frmFile, frmDir, true, definition.password, null);
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    private void validateFrmFile(File workingDir, File frmDir, File ddxFile, File frmDdxFile, Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nValidating FRM...", session);
        this.wakeUpProgressMonitor();
        if (definition.type == null) {
            if (!frmDdxFile.exists()) {
                this.throwInvalidFrmException("Deployment Descriptor not found in FRM.");
            }
            CtxDeploymentDescriptor ddx = DeployUtils.getDeploymentDescriptor(frmDdxFile.getAbsolutePath());
            if (!StringUtils.equalsNullSafe(this.getNodeName(definition), ddx.getContextName())) {
                this.throwInvalidFrmException("Target Node name [" + this.getNodeName(definition) + "] does not match Backup Node name [" + ddx.getContextName() + "].");
            }
            if (!StringUtils.equalsNullSafe(((RuntimeContext)this.callable).getDomain(), ddx.getReferral())) {
                this.throwInvalidFrmException("Target Domain [" + ((RuntimeContext)this.callable).getDomain() + "] does not match Backup Node Domain [" + ddx.getReferral() + "].");
            }
            try {
                this.authenticate(ddx.getSecurityPrincipal(), ddx.getSecurityCredentials());
            }
            catch (SecurityManagerException exception) {
                this.throwInvalidFrmException(exception.getErrorMessage());
            }
        }
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    protected void throwInvalidFrmException(String errorMessage) throws Exception {
        throw new FabricException(errorMessage + " Use 'force' flag to override this check.");
    }

    protected void unloadNode(Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nWARNING: Current session will be disconnected after unloading the node.\nInformation about further steps will be available in the Restore log.\n", session);
        this.raiseSLMessage("\nUnloading node...", session);
        this.wakeUpProgressMonitor();
        this.relaunchInProgress = true;
        ((RuntimeContext)this.callable).getShutdownListener().onShutdown();
        ContainerLockSupport.getCurrentNodeLock().removeLockFile();
        Utils.sleep(200L);
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    private void cleanWorkingDir(File workingDir, File frmDir, File ddxFile, File frmDdxFile, File logFile, Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nCleaning working directory...", session);
        this.wakeUpProgressMonitor();
        HashSet<File> excludedFiles = new HashSet<File>(Arrays.asList(frmDir));
        if (definition.type == null || definition.type == OperationType.PRESERVE) {
            excludedFiles.add(ddxFile);
            frmDdxFile.delete();
            if (definition.type == OperationType.PRESERVE) {
                excludedFiles.add(new File(workingDir, SECURITY_PATH).getCanonicalFile());
                FileIOUtils.deleteFileDir(new File(frmDir, SECURITY_PATH).getCanonicalFile());
            }
        }
        if (logFile != null) {
            excludedFiles.add(logFile);
        }
        this.addExcludedFiles(workingDir, excludedFiles);
        FileIOUtils.deleteFileDir(workingDir, excludedFiles);
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    protected void addExcludedFiles(File workingDir, Set<File> excludedFiles) {
    }

    private void restoreWorkingDir(File workingDir, File frmDir, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nRestoring working directory...", session);
        this.wakeUpProgressMonitor();
        this.deleteExcludedFiles(frmDir);
        FileIOUtils.move(frmDir, workingDir);
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    protected void deleteExcludedFiles(File frmDir) {
        new File(frmDir, "manifest.frmm").delete();
        new File(frmDir, LOG_FILENAME).delete();
    }

    protected void loadNode(Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\n\nLoading node...", session);
        this.wakeUpProgressMonitor();
        if (((RuntimeContext)this.callable).getContainer() instanceof Container) {
            ((Container)((RuntimeContext)this.callable).getContainer()).relaunch();
        }
        this.callable = RuntimeContext.getInstance();
        this.relaunchInProgress = false;
        this.sleepProgressMonitor();
        this.raiseOK(session);
    }

    private void onExit(File frmDir, File frmFile) {
        FileIOUtils.deleteFileDir(frmDir);
        frmFile.delete();
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logWriter = null;
        }
    }

    protected void raiseOK(MFSession session) throws FabricException {
        this.raiseSLMessage(" OK", session);
    }

    @Override
    protected void raiseSLMessage(String message, MFSession session) {
        if (this.canRaiseSLMessage(session)) {
            super.raiseSLMessage(message, session);
        }
        this.writeInLog(message);
        Utils.sleep(10L);
    }

    @Override
    protected void raiseSLMessageError(String message, MFSession session) {
        if (this.canRaiseSLMessage(session)) {
            super.raiseSLMessageError(message, session);
        }
        this.writeInLog("\nERROR: " + message + "\n");
    }

    protected boolean canRaiseSLMessage(MFSession session) {
        return !this.relaunchInProgress;
    }

    protected void writeInLog(String message) {
        try {
            if (this.logWriter != null && message != null) {
                this.logWriter.write(message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static class Definition
    extends AbstractFrmNodeOperation.Definition {
        protected String password;
        protected OperationType type;

        public Definition(String operationName, String nodeName, String frmPath, boolean isAsync, String password) {
            super(operationName, nodeName, frmPath, isAsync);
            this.password = password;
        }
    }

    public static enum OperationType {
        FORCE,
        PRESERVE;

    }
}

