/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.runtime.mf.operation.repository.ImportOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractExportImportOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LoadFrmOperation
extends AbstractFrmOperation<RuntimeContext> {
    public static final String NAME = "load frm";

    public LoadFrmOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LOAD FRM").addParameter(new SLFilePathParameter("FrmPath"));
        this.syntax.addModifier(new Modifier("FORCE", false));
        this.syntax.setDescription("Loads all entries (according to FRM manifest inside FRM file) from specified FRM file into the current node.");
        this.syntax.setExamples("load frm './myfrm.frm'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("FrmPath").getValue(), statement.existsModifier("FORCE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SLFileUtils frm = (SLFileUtils)new SLFileUtilsFactory().create(session, definition.frmPath);
        frm.setVerbose(false);
        File frmDir = FileIOUtils.createTempDir(new File(((RuntimeContext)this.callable).getStartupDir()));
        try {
            this.raiseSLMessage("\nOpening FRM...", session);
            ImportOperation.extractFrmToTmpDir(frmDir, frm);
            this.raiseSLMessage("\nExtracting FRM Manifest...\n", session);
            File manifestFile = new File(frmDir, "manifest.frmm");
            if (!manifestFile.exists()) {
                throw new Exception("Manifest not found in FRM file.");
            }
            FrmManifest manifest = (FrmManifest)LoadFrmOperation.getSerializer().deserialize(Files.readAllBytes(manifestFile.toPath()));
            this.loadEntry(manifest, frmDir, session, FrmEntityType.OBJECT, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.EXT_ARCHIVE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.ARCHIVE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.PACKAGE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.CLIENT_FACTORY, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.JDBC_FACTORY, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.TRANSPORT_FACTORY, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.SEMANTIC_TYPE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.EVENT_PROTOTYPE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.ARTIFACT, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.GVAR, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.FILE_DESCRIPTOR, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.SERVICE, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.HTTP_ACCEPTOR, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.WORKING_DIR, definition.force);
            this.loadEntry(manifest, frmDir, session, FrmEntityType.MLCACHE, definition.force);
        }
        finally {
            if (frmDir != null) {
                FileIOUtils.deleteFileDir(frmDir);
            }
        }
        return new SLResponse();
    }

    private void loadEntry(FrmManifest manifest, File frmDir, MFSession session, FrmEntityType entityType, boolean force) throws Exception {
        List<AbstractExportImportOperation.Artifact> entryArtifacts;
        this.raiseSLMessage("\nLoading entries of type (" + entityType.getPrintName() + ")...", session);
        List<String> entryNames = this.getEntryNamesFor(manifest, entityType, frmDir);
        if (entryNames.size() > 0) {
            this.raiseSLMessage("\n", session);
        }
        if (!(entryArtifacts = ImportOperation.getArtifactsFromTmpDir(entityType, entryNames, null, frmDir, session, ((RuntimeContext)this.callable).getXSerializer())).isEmpty()) {
            ImportOperation.importArtifacts(entryArtifacts, frmDir, this, new AbstractExportImportOperation.Definition(force), session);
        }
    }

    private List<String> getEntryNamesFor(FrmManifest manifest, FrmEntityType entityType, File frmDir) throws Exception {
        HashSet includeEntities = manifest.getIncludeEntities() != null ? (Set)manifest.getIncludeEntities().getOrDefault((Object)entityType, new HashSet()) : new HashSet();
        HashSet excludeEntities = manifest.getExcludeEntities() != null ? (Set)manifest.getExcludeEntities().getOrDefault((Object)entityType, new HashSet()) : new HashSet();
        boolean includeAll = includeEntities != null && includeEntities.contains(FrmManifest.ALL);
        boolean excludeAll = excludeEntities != null && excludeEntities.contains(FrmManifest.ALL);
        File entryDir = new File(frmDir, entityType.getRelativePath());
        return this.listFrmEntities(entityType, entryDir).stream().filter(name -> includeAll && !excludeAll && !FrmEntity.contains(excludeEntities, FrmFileWriter.convertFrmEntity(entityType, new FrmEntity((String)name, "")), entityType) || FrmEntity.contains(includeEntities, FrmFileWriter.convertFrmEntity(entityType, new FrmEntity((String)name, "")), entityType)).map(name -> {
            switch (entityType) {
                case CLIENT_FACTORY: 
                case JDBC_FACTORY: 
                case TRANSPORT_FACTORY: 
                case SERVICE: 
                case PACKAGE: 
                case SEMANTIC_TYPE: {
                    if (entityType.getExtension().length() <= 0 || !name.endsWith(entityType.getExtension())) break;
                    name = name.substring(0, name.length() - entityType.getExtension().length());
                }
            }
            return name;
        }).collect(Collectors.toList());
    }

    private List<String> listFrmEntities(FrmEntityType entityType, File entryDir) throws Exception {
        if (entityType == FrmEntityType.EVENT_PROTOTYPE) {
            return ImportOperation.listEventPrototypeFiles(entryDir);
        }
        if (entityType == FrmEntityType.MLCACHE) {
            return ImportOperation.listMlcache(entryDir);
        }
        if (entityType == FrmEntityType.OBJECT) {
            return ImportOperation.listObjects(entryDir, "");
        }
        return Arrays.asList(Optional.ofNullable(entryDir.list()).orElse(new String[0]));
    }

    public static class Definition
    extends AbstractSLStatement {
        private String frmPath;
        private boolean force;

        public Definition(String frmPath, boolean force) {
            super(LoadFrmOperation.NAME);
            this.frmPath = frmPath;
            this.force = force;
        }
    }
}

