/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;

public class ListFrmManifestsOperation
extends AbstractFrmOperation<RuntimeContext> {
    public static final String NAME = "list frm manifests";

    public ListFrmManifestsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST FRM MANIFESTS");
        this.syntax.setDescription("Lists existing Fabric Resource Module manifests in the current node.");
        this.syntax.setExamples(NAME);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile("resources")) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().createDirectory("resources");
        }
        List<String> resourceFiles = ((RuntimeContext)this.callable).getRepositoryAccessor().listFiles("resources");
        RowMetaData meta = new RowMetaData();
        ListFrmManifestsOperation.addColumn(meta, "Manifest");
        RowSet result = new RowSet(meta);
        for (String file : resourceFiles) {
            if (!file.endsWith(".frmm")) continue;
            result.addToRowSet(new Object[]{file.substring(0, file.length() - ".frmm".length())});
        }
        return new SLResponse(result);
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListFrmManifestsOperation.NAME);
        }
    }
}

